import type { RpcResponse, ActionMSEnum,ActionPositionISTEnum,AllItemGIKTType,ApikeyACITType,ArgsAddBiBoardInput,ArgsAuthEmailInput,ArgsAuthEmailPrepareInput,ArgsAuthPhoneInput,ArgsAuthSocInput,ArgsCalculateBiBlockInput,ArgsCollectionInput,ArgsDataInput,ArgsDeleteBiBoardInput,ArgsDeleteDataInput,ArgsDeleteExportInput,ArgsDisplayValuesInput,ArgsEmptyDataInput,ArgsFilterInput,ArgsGeneratePaymentLinkInput,ArgsGeocodeInput,ArgsGeolocationInput,ArgsHashInput,ArgsMakeExportInput,ArgsMakeStatementExportInput,ArgsMoveUpdateInput,ArgsNewApiKeyInput,ArgsRemoveApiKeyInput,ArgsRunActionInput,ArgsStagesTotalInput,ArgsUpdateBiBoardInput,ArgsUpdateInput,ArgsUpdateProfileInput,AssetCIPTType,AuthEPSType,AuthEmailPrepareCFIType,BalanceFPType,BalancePaymentType,BiAggregateEnum,BiBlockEnum,BiBlockInput,BiBlockType,BiBlockValueItemType,BiBlockValueType,BiGroupTransformEnum,ByCoordLInput,ByStringLSInput,CollectionCDRSType,CollectionMenuAMType,CollectionRelationType,CompositeTypeGType,DTType,DashboardBlockTypeBCLPEnum,DatumDHLTType,DatumDIType,DatumIMType,DeviceInfoMNPUInput,DirectionADEnum,DisplayValueDLOTType,EmptyDatumIMType,FieldDescriptionItemType,FieldDescriptionType,FileAudioFileType,FileDocumentFileType,FileImageFileType,FileVideoFileType,FilterPresetFKTType,GatewayDIKTType,GeoRegionGType,GeolocationILType,GeopointType,GradientAPType,GroupIKTType,InitACPTType,ItemMType,MenuAMType,MenuCGITType,MenuItemChildType,MenuItemType,MetumACFPType,MongoPointType,MongoPolygonType,PaletteCOType,PayloadUType,ProfileBCDSType,RunActionPType,ShmBiBoardInput,ShmBiBoardType,ShmExportType,ShmMsgAuthLinkType,ShmMsgAuthType,SortDFInput,StagesTotalMType,StatusDEPEnum,StructureType,TypeABCDEFGHILMPRSTUEnum,TypeDSEnum,UpdateDType,UpdateProfileIMType,ValueMType,childGIKTType } from './types';
export const rpc = {
addBiBoard: ( params: ArgsAddBiBoardInput) => {
            return rpcClient.call<ArgsAddBiBoardInput, ShmBiBoardType | null, null>(
               'addBiBoard',params, []
            );
             },
allCollections: ( ) => {
            return rpcClient.call<{}, StructureType[] | null, null>(
               'allCollections',{}, []
            );
             },
apikeys: ( ) => {
            return rpcClient.call<{}, ApikeyACITType[] | null, null>(
               'apikeys',{}, []
            );
             },
audioUpload: (formData:FormData) => {
            return rpcClient.callFormData<FileAudioFileType | null>(
               'audioUpload', formData
            );
             },
authEmail: ( params: ArgsAuthEmailInput) => {
            return rpcClient.call<ArgsAuthEmailInput, string | null, null>(
               'authEmail',params, []
            );
             },
authEmailPrepare: ( params: ArgsAuthEmailPrepareInput) => {
            return rpcClient.call<ArgsAuthEmailPrepareInput, AuthEmailPrepareCFIType | null, null>(
               'authEmailPrepare',params, []
            );
             },
authPhone: ( params: ArgsAuthPhoneInput) => {
            return rpcClient.call<ArgsAuthPhoneInput, ShmMsgAuthType | null, null>(
               'authPhone',params, []
            );
             },
authSoc: ( params: ArgsAuthSocInput) => {
            return rpcClient.call<ArgsAuthSocInput, string | null, null>(
               'authSoc',params, []
            );
             },
biBoards: ( ) => {
            return rpcClient.call<{}, ShmBiBoardType[] | null, null>(
               'biBoards',{}, []
            );
             },
calculateBiBlock: ( params: ArgsCalculateBiBlockInput) => {
            return rpcClient.call<ArgsCalculateBiBlockInput, BiBlockValueType | null, null>(
               'calculateBiBlock',params, []
            );
             },
collection: ( params: ArgsCollectionInput) => {
            return rpcClient.call<ArgsCollectionInput, CollectionCDRSType | null, null>(
               'collection',params, []
            );
             },
compositeTypes: ( ) => {
            return rpcClient.call<{}, CompositeTypeGType | null, null>(
               'compositeTypes',{}, []
            );
             },
data: ( params: ArgsDataInput) => {
            return rpcClient.call<ArgsDataInput, DatumDHLTType | null, null>(
               'data',params, []
            );
             },
deleteBiBoard: ( params: ArgsDeleteBiBoardInput) => {
            return rpcClient.call<ArgsDeleteBiBoardInput, boolean | null, null>(
               'deleteBiBoard',params, []
            );
             },
deleteData: ( params: ArgsDeleteDataInput) => {
            return rpcClient.call<ArgsDeleteDataInput, boolean | null, null>(
               'deleteData',params, []
            );
             },
deleteExport: ( params: ArgsDeleteExportInput) => {
            return rpcClient.call<ArgsDeleteExportInput, boolean | null, null>(
               'deleteExport',params, []
            );
             },
displayValues: ( params: ArgsDisplayValuesInput) => {
            return rpcClient.call<ArgsDisplayValuesInput, DisplayValueDLOTType | null, null>(
               'displayValues',params, []
            );
             },
documentUpload: (formData:FormData) => {
            return rpcClient.callFormData<FileDocumentFileType | null>(
               'documentUpload', formData
            );
             },
emptyData: ( params: ArgsEmptyDataInput) => {
            return rpcClient.call<ArgsEmptyDataInput, EmptyDatumIMType | null, null>(
               'emptyData',params, []
            );
             },
filter: ( params: ArgsFilterInput) => {
            return rpcClient.call<ArgsFilterInput, StructureType | null, null>(
               'filter',params, []
            );
             },
generatePaymentLink: ( params: ArgsGeneratePaymentLinkInput) => {
            return rpcClient.call<ArgsGeneratePaymentLinkInput, string | null, null>(
               'generatePaymentLink',params, []
            );
             },
geocode: ( params: ArgsGeocodeInput) => {
            return rpcClient.call<ArgsGeocodeInput, GeopointType[] | null, null>(
               'geocode',params, []
            );
             },
geolocation: ( params: ArgsGeolocationInput) => {
            return rpcClient.call<ArgsGeolocationInput, GeolocationILType | null, null>(
               'geolocation',params, []
            );
             },
hash: ( params: ArgsHashInput) => {
            return rpcClient.call<ArgsHashInput, string | null, null>(
               'hash',params, []
            );
             },
imageUpload: (formData:FormData) => {
            return rpcClient.callFormData<FileImageFileType | null>(
               'imageUpload', formData
            );
             },
init: ( ) => {
            return rpcClient.call<{}, InitACPTType | null, null>(
               'init',{}, []
            );
             },
lastBalanceOperations: ( ) => {
            return rpcClient.call<{}, BalancePaymentType[] | null, null>(
               'lastBalanceOperations',{}, []
            );
             },
listExport: ( ) => {
            return rpcClient.call<{}, ShmExportType[] | null, null>(
               'listExport',{}, []
            );
             },
makeExport: ( params: ArgsMakeExportInput) => {
            return rpcClient.call<ArgsMakeExportInput, boolean | null, null>(
               'makeExport',params, []
            );
             },
makeStatementExport: ( params: ArgsMakeStatementExportInput) => {
            return rpcClient.call<ArgsMakeStatementExportInput, boolean | null, null>(
               'makeStatementExport',params, []
            );
             },
menu: ( ) => {
            return rpcClient.call<{}, MenuAMType | null, null>(
               'menu',{}, []
            );
             },
moveUpdate: ( params: ArgsMoveUpdateInput) => {
            return rpcClient.call<ArgsMoveUpdateInput, boolean | null, null>(
               'moveUpdate',params, []
            );
             },
newApiKey: ( params: ArgsNewApiKeyInput) => {
            return rpcClient.call<ArgsNewApiKeyInput, string | null, null>(
               'newApiKey',params, []
            );
             },
profile: ( ) => {
            return rpcClient.call<{}, ProfileBCDSType | null, null>(
               'profile',{}, []
            );
             },
removeApiKey: ( params: ArgsRemoveApiKeyInput) => {
            return rpcClient.call<ArgsRemoveApiKeyInput, boolean | null, null>(
               'removeApiKey',params, []
            );
             },
runAction: ( params: ArgsRunActionInput) => {
            return rpcClient.call<ArgsRunActionInput, RunActionPType | null, null>(
               'runAction',params, []
            );
             },
stagesTotal: ( params: ArgsStagesTotalInput) => {
            return rpcClient.call<ArgsStagesTotalInput, StagesTotalMType | null, null>(
               'stagesTotal',params, []
            );
             },
update: ( params: ArgsUpdateInput) => {
            return rpcClient.call<ArgsUpdateInput, UpdateDType | null, null>(
               'update',params, []
            );
             },
updateBiBoard: ( params: ArgsUpdateBiBoardInput) => {
            return rpcClient.call<ArgsUpdateBiBoardInput, ShmBiBoardType | null, null>(
               'updateBiBoard',params, []
            );
             },
updateProfile: ( params: ArgsUpdateProfileInput) => {
            return rpcClient.call<ArgsUpdateProfileInput, UpdateProfileIMType | null, null>(
               'updateProfile',params, []
            );
             },
videoUpload: (formData:FormData) => {
            return rpcClient.callFormData<FileVideoFileType | null>(
               'videoUpload', formData
            );
             },
};
export const compositeTypes = rpc.compositeTypes;
export const geolocation = rpc.geolocation;
export const imageUpload = rpc.imageUpload;
export const videoUpload = rpc.videoUpload;
export const audioUpload = rpc.audioUpload;
export const documentUpload = rpc.documentUpload;
export const authEmail = rpc.authEmail;
export const authEmailPrepare = rpc.authEmailPrepare;
export const authSoc = rpc.authSoc;
export const authPhone = rpc.authPhone;
export const profile = rpc.profile;
export const updateProfile = rpc.updateProfile;
export const init = rpc.init;
export const allCollections = rpc.allCollections;
export const addBiBoard = rpc.addBiBoard;
export const updateBiBoard = rpc.updateBiBoard;
export const deleteBiBoard = rpc.deleteBiBoard;
export const biBoards = rpc.biBoards;
export const calculateBiBlock = rpc.calculateBiBlock;
export const menu = rpc.menu;
export const displayValues = rpc.displayValues;
export const collection = rpc.collection;
export const emptyData = rpc.emptyData;
export const geocode = rpc.geocode;
export const deleteData = rpc.deleteData;
export const hash = rpc.hash;
export const data = rpc.data;
export const deleteExport = rpc.deleteExport;
export const makeExport = rpc.makeExport;
export const makeStatementExport = rpc.makeStatementExport;
export const listExport = rpc.listExport;
export const filter = rpc.filter;
export const apikeys = rpc.apikeys;
export const removeApiKey = rpc.removeApiKey;
export const newApiKey = rpc.newApiKey;
export const moveUpdate = rpc.moveUpdate;
export const update = rpc.update;
export const runAction = rpc.runAction;
export const stagesTotal = rpc.stagesTotal;
export const generatePaymentLink = rpc.generatePaymentLink;
export const lastBalanceOperations = rpc.lastBalanceOperations;

const uuidv4 = (): string => {
   return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
      const r = crypto.getRandomValues(new Uint8Array(1))[0] & 15;
      const v = c === 'x' ? r : (r & 0x3) | 0x8;
      return v.toString(16);
   });
}

const xorEncrypt = (text: string, key: string) => {
   const textBytes = new TextEncoder().encode(text);
   const keyBytes = new TextEncoder().encode(key);

   const result = new Uint8Array(textBytes.length);
   for (let i = 0; i < textBytes.length; i++) {
      result[i] = textBytes[i] ^ keyBytes[i % keyBytes.length];
   }


   return btoa(String.fromCharCode(...Array.from(result)));
}

const xorDecrypt = (encodedText: string, key: string) => {
   const binaryString = atob(encodedText);
   const textBytes = new Uint8Array(binaryString.length);
   for (let i = 0; i < binaryString.length; i++) {
      textBytes[i] = binaryString.charCodeAt(i);
   }

   const keyBytes = new TextEncoder().encode(key);
   const result = new Uint8Array(textBytes.length);

   for (let i = 0; i < textBytes.length; i++) {
      result[i] = textBytes[i] ^ keyBytes[i % keyBytes.length];
   }

   return new TextDecoder().decode(result);
}


export class rpcClient {
   private static endpoints: string[] = [];
   private static readonly ENDPOINT_INDEX_KEY = 'rpcClient_endpointIndex';
   private static currentEndpointIndex: number = 0;
   private static initialized: boolean = false;
   private static headers: Record<string, string> = {};
   private static tokenGetter: (() => string | null) | null = null;
   private static unauthorizedHandler: (() => void) | null = null;
   private static networkErrorHandler: (() => void) | null = null;
   private static toastHandler: ((message: string) => void) | null = null;
   private static storage: { save: (key: string, value: string) => Promise<void>; get: (key: string) => Promise<string | null> } | null = null;


   private static defaultExtensions: DefaultExtensionsType = [];

   public static setDefaultExtensions(extensions: DefaultExtensionsType): void {
      this.defaultExtensions = extensions;
   }

   private static abortControllerTimeout: number = 30000;

   public static setAbortControllerTimeout(timeout: number): void {
      this.abortControllerTimeout = timeout;
   }

   public static setStorage(storage: { save: (key: string, value: string) => Promise<void>; get: (key: string) => Promise<string | null> }): void {
      this.storage = storage;
   }

   private static useEncrypt: boolean = false;

   public static setUseEncrypt(useEncrypt: boolean): void {
      this.useEncrypt = useEncrypt;
   }

   public static setNetworkErrorHandler(handler: () => void): void {
      this.networkErrorHandler = handler;
   }

   public static async init(): Promise<void> {
      if (this.initialized) return;
      if (this.storage) {
         try {
            const savedIndex = await this.storage.get(this.ENDPOINT_INDEX_KEY);
            if (savedIndex !== null) {
               const index = parseInt(savedIndex, 10);
               if (!isNaN(index) && index >= 0 && index < this.endpoints.length) {
                  this.currentEndpointIndex = index;
               }
            }
         } catch (error) {
            console.log('⚠️ Ошибка при загрузке индекса endpoint:', error);
         }
      } else {
         this.currentEndpointIndex = 0;
      }
      this.initialized = true;
   }

   private static async saveEndpointIndex(): Promise<void> {
      if (!this.storage) return;
      try {
         await this.storage.save(this.ENDPOINT_INDEX_KEY, this.currentEndpointIndex.toString());
      } catch (error) {
         console.log('⚠️ Ошибка при сохранении индекса endpoint:', error);
      }
   }

   private static switchToNextEndpoint(): void {
      if (this.endpoints.length <= 1) return;
      this.currentEndpointIndex = (this.currentEndpointIndex + 1) % this.endpoints.length;
      this.saveEndpointIndex();
   }

   private static async waitForEndpoints(): Promise<void> {
      if (this.endpoints.length > 0) return;

      // Ждем 1 секунду и проверяем еще раз
      await new Promise(resolve => setTimeout(resolve, 1000));

      if (this.endpoints.length === 0) {
         throw new Error('Endpoints are not set');
      }
   }

   private static getCurrentEndpoint(): string {
      if (this.endpoints.length === 0) throw new Error('Endpoints are not set');
      return this.endpoints[this.currentEndpointIndex];
   }

   public static getCurrentEndpointDomain(): string {

      let http = this.getCurrentEndpoint().split('://')[0];
      let path = this.getCurrentEndpoint().split('://')[1];

      let firstPart = path.split('/')[0];

      return `${http}://${firstPart}`;
   }

   private static isNetworkError(error: any): boolean {
      return (
         error.name === 'AbortError' ||
         error.name === 'TimeoutError' ||
         error.name === 'TypeError' ||
         error.message?.includes('Network request failed') ||
         error.message?.includes('Failed to fetch') ||
         error.message?.includes('NetworkError')
      );
   }

   public static setToken(getter: () => string | null): void {
      this.tokenGetter = getter;
   }

   public static setUnauthorizedHandler(handler: () => void): void {
      this.unauthorizedHandler = handler;
   }

   public static setToast(handler: (message: string) => void): void {
      this.toastHandler = handler;
   }

   public static setEndpoints(urls: string[]): void {
      this.endpoints = urls;
      this.currentEndpointIndex = 0;
      this.initialized = false;
   }

   public static getToken(): string | null {
      if (this.tokenGetter) return this.tokenGetter();
      return null;
   }

   public static setHeaders(headers: Record<string, string>): void {
      this.headers = { ...this.headers, ...headers };
   }

   private static handleError(error: any): void {
      if (error?.type === 'UNAUTHORIZED' || error?.type === 'UNAUTHENTICATED') {
         if (this.unauthorizedHandler) {
            this.unauthorizedHandler();
         }
      }
      if (error?.message) {
         if (this.toastHandler) {
            this.toastHandler(error.message);
         }
      }
   }

   public static async callFormData<R>(method: string, formData: FormData): Promise<R> {
      await this.waitForEndpoints();
      const endpoint = this.getCurrentEndpoint();

      formData.append('method', method);

      let _token = this.getToken();
      if (_token) {
         formData.append('token', _token);
      }

      formData.append('timezone', Intl.DateTimeFormat().resolvedOptions().timeZone);

      const context = this.useEncrypt ? uuidv4() : undefined;

      if (this.useEncrypt && context) {
         formData.append('context', context);
      }


      const headers = { ...this.headers };
      delete headers['Content-Type'];

      const controller = new AbortController();
      const timeoutId = setTimeout(() => {
         controller.abort();
      }, this.abortControllerTimeout);

      return fetch(endpoint, { method: 'POST', headers, body: formData, signal: controller.signal })
         .then(res => res.json())
         .then((json: RpcResponse<R>) => {
            clearTimeout(timeoutId);

            if (this.useEncrypt && context) {

               if (json.result) {
                  json.result = JSON.parse(xorDecrypt(json.result as string, context));
               }
               if (json.extensions) {
                  json.extensions = JSON.parse(xorDecrypt(json.extensions as string, context));
               }
            }


            if (json?.error) {
               this.handleError(json.error);
               throw json.error;
            }
            this.saveEndpointIndex();
            return json.result as R;
         })
         .catch(err => {
            clearTimeout(timeoutId);
            if (this.isNetworkError(err)) {

               if (this.networkErrorHandler) {
                  this.networkErrorHandler();
               }

               this.switchToNextEndpoint();
            }
            throw err;
         });
   }

   public static async call<P, R, E>(method: string, params?: P, extensions?: Array<string>): Promise<RpcResponse<R, E>> {
      await this.waitForEndpoints();
      const endpoint = this.getCurrentEndpoint();


      const context = this.useEncrypt ? uuidv4() : undefined;


      let _extensions = extensions != undefined ? extensions : this.defaultExtensions;


      const body = {
         method, extensions: _extensions, context: context, token: this.getToken(),
         params: params ? context ? xorEncrypt(JSON.stringify(params ?? {}), context) : params : undefined,
         id: Date.now().toString()
      };

      console.log('🚀🚀🚀 method: ', method, ' RPC Endpoint: ', endpoint);
      console.log('🚀🚀🚀 method: ', method, ' RPC Body: ', JSON.stringify(body));


      const controller = new AbortController();
      const timeoutId = setTimeout(() => {
         controller.abort();
      }, this.abortControllerTimeout);

      return fetch(endpoint, {
         method: 'POST', headers: {
            'Content-Type': 'application/json',
            'timezone': Intl.DateTimeFormat().resolvedOptions().timeZone,
            ...this.headers
         }, body: JSON.stringify(body),
         signal: controller.signal
      })
         .then(res => res.json())
         .then((json: RpcResponse<R>) => {
            clearTimeout(timeoutId);

            if (this.useEncrypt && context) {

               if (json.result) {
                  json.result = JSON.parse(xorDecrypt(json.result as string, context));
               }
               if (json.extensions) {
                  json.extensions = JSON.parse(xorDecrypt(json.extensions as string, context));
               }
            }

            console.log('🍪🍪🍪 method: ', method, ' RPC Response: ', JSON.stringify(json));
            if (json?.error) {
               this.handleError(json.error);
               throw json.error;
            }
            this.saveEndpointIndex();

            if (json?.extensions) {
               ExtensionsStore.addToStore(json.extensions);
            }

            return json as RpcResponse<R, E>;
         })
         .catch(err => {
            clearTimeout(timeoutId);
            if (this.isNetworkError(err)) {
               if (this.networkErrorHandler) {
                  this.networkErrorHandler();
               }
               this.switchToNextEndpoint();
            }
            console.log('🛑🛑🛑 RPC Error: ', JSON.stringify(body));
            throw err;
         });
   }
}


        

        type DefaultExtensionsType = ("")[];
        
        type ExtensionsStoreType = {};
        
        type ExtensionsStoreInputType = {};
        
        export class ExtensionsStore {
        

        private static store: ExtensionsStoreType = {};
        
        public static addToStore(value: ExtensionsStoreInputType) {
        
        


        }

        


        
        
          }