import { Copy } from 'lucide-react';

import { Button } from '@/components/ui/button';
import {
    Card,
    CardFooter,
} from '@/components/ui/card';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { copyTextToClipboard } from '@/utils/helpers';

const ContentOnlyView = (props: {
    onOpen?: () => void;
    placeholder: string;
    children?: any;
    copyString?: string;
}) => {

    const { color } = useAppConfig();

    return <Card
        className={`mb-3 ${props.copyString ? 'active:opacity-80' : ''}`}
        onClick={() => {

            if (props.onOpen) {
                props.onOpen();
            } else {

                if (props.copyString) {


                    copyTextToClipboard(props.copyString);


                }
            }
        }}
        style={{
            wordBreak: "break-all",
            cursor: !!props.copyString ? 'pointer' : 'default',
        }}
    >
        <div
            className='text-xs font-medium'
        >{props.placeholder}</div>

        <div>
            {props.children != undefined && props.children != null && props.children != "" ? props.children : <span className='text-gray-300 text-xs'>{props.placeholder}</span>}


        </div>
        <CardFooter>
            <Button variant="secondary" size="icon-sm" onClick={() => {
                //     copyTextToClipboard(props.copyString);
            }}>
                <Copy />
            </Button>
        </CardFooter>
        {/*props.onOpen ? <div className=" mt-2 absolute right-2 top-0">

            <FaRegWindowRestore size={18} color={color} />
        </div> :

            !!props.copyString && <div className="text-xs text-gray-200 text-center mt-2 absolute right-2 top-0">

                <FaCopy size={18} />
            </div>*/}

    </Card>
}

export default ContentOnlyView;