import {
  useEffect,
  useState,
} from 'react';

import _ from 'lodash';
import {
  Check,
  ChevronsUpDown,
} from 'lucide-react';

import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import {
  Popover,
  PopoverContent,
  PopoverTrigger,
} from '@/components/ui/popover';
import { Lang } from '@/lang/Lang';
import { cn } from '@/lib/utils';

import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import { ItemDataProps } from './types';

export type ItemType = {
  label: string;
  value: string;
};

export const EnumsData = (props: ItemDataProps) => {


  const [localValue, setLocalValue] = useState<string[]>(props.getValue() ?? []);

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);




  if (props.onlyShow || !props.structure.editable) {

    return <div>
      <DataLabel {...props} />
      <Button variant="secondary" className='w-full flex items-center justify-between'>
        {localValue && localValue.length > 0 ? _.map(localValue, (val) => {
          return <Badge key={val}>{props.structure.itemType?.values?.[val] ?? ""}</Badge>
        }) : Lang.key('no_data_short')}
      </Button>
      <DataDescription {...props} />
    </div>




  }






  const [open, setOpen] = useState(false);


  return <div className='w-full '>
    <DataLabel {...props} />

    <Popover open={open} onOpenChange={setOpen}>
      <PopoverTrigger className='w-full' >
        <Button
          variant="outline"
          role="combobox"
          className="w-full justify-between h-auto"
        >

          <div className='flex flex-wrap gap-2'> {localValue && localValue.length > 0 ? _.map(localValue, (val) => {
            return <Badge key={val}>{props.structure.itemType?.values?.[val] ?? ""}</Badge>
          }) : Lang.key('select_value')}
          </div>
          <ChevronsUpDown className="opacity-50" />

        </Button>
      </PopoverTrigger>
      <PopoverContent
        className="p-0 w-[var(--radix-popover-trigger-width)]"
      >
        <div
          className="p-1"
          style={{
            maxHeight: '400px',
            overflowY: 'auto',
            overflowX: 'hidden',
            WebkitOverflowScrolling: 'touch'
          }}
          onWheel={(e) => {
            e.stopPropagation();
            const target = e.currentTarget;
            target.scrollTop += e.deltaY;
            e.preventDefault();
          }}
        >
          {_.map(props.structure.itemType?.values, (value, key) => (
            <div
              key={key}
              onClick={() => {
                setLocalValue((prev) => {
                  if (prev.includes(key)) {
                    return prev.filter((item: any) => item !== key);
                  } else {
                    return [...prev, key];
                  }
                });
              }}
              className={cn(
                "relative flex cursor-pointer select-none items-center rounded-sm px-2 py-1.5 text-sm outline-none hover:bg-accent hover:text-accent-foreground",
                localValue?.includes(key) && "bg-accent text-accent-foreground"
              )}
            >
              {value}
              <Check
                className={cn(
                  "ml-auto h-4 w-4",
                  localValue?.includes(key) ? "opacity-100" : "opacity-0"
                )}
              />
            </div>
          ))}
        </div>
      </PopoverContent>
    </Popover>

    <DataDescription {...props} />
  </div>





};
