import { mediaBrowserDialogRef } from '@/components/MediaBrowserDialog';

const ImagePreview = ({ url }: { url: string }) => {





    return <div

        onClick={() => {
            if (!url) return;

            mediaBrowserDialogRef.current?.open({
                url: url,
                type: "image",
            });
        }}

        className='flex items-center justify-center cursor-pointer'
        style={{

            width: '100%',
            height: 100,
            borderRadius: 8,
            overflow: 'hidden',



            backgroundImage: `url(${url})`,
            backgroundSize: 'cover',
            backgroundPosition: 'center',
            backgroundRepeat: 'no-repeat',
        }}
    >
        <div style={{
            borderRadius: 8,
            overflow: 'hidden',

            width: '100%',
            height: '100%',
            backgroundColor: 'rgba(0,0,0,0.5)',
        }}>
            <div

                style={{

                    width: '100%',
                    height: '100%',





                    backgroundImage: `url(${url})`,
                    backgroundSize: "contain",
                    backgroundPosition: 'center',
                    backgroundRepeat: 'no-repeat',
                }}
            />

        </div>
    </div>



}

export default ImagePreview;