import React, {
  useEffect,
  useState,
} from 'react';

import _ from 'lodash';

import { GeoRegionGType } from '@/api/types';
import { dialogRegionEditorRef } from '@/components/DialogRegionEditor';
import { Button } from '@/components/ui/button';
import { Lang } from '@/lang/Lang';

import DataDescription from '../components/DataDescription';
import DataLabel from '../components/DataLabel';
import { ItemDataProps } from '../types';
import GmMap from './components/GmMap';

// Стили для каждого слоя

export const GeoRegionData = (props: ItemDataProps) => {




  const [localValue, setLocalValue] = useState<GeoRegionGType[]>(props.getValue());

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);






  return <>

    <DataLabel {...props} />

    <GmMap
      height={200}
      onlyView={true}
      values={localValue ?? []}
      onChange={(val) => {
        setLocalValue(val);
      }}
    />
    <DataDescription {...props} />
    <Button

      className='w-full'
      onClick={() => {
        dialogRegionEditorRef.current?.open({
          initialValues: localValue ?? [],
          onSave: (val) => {
            setLocalValue(val);
          }
        });
      }}>{Lang.key('edit')}</Button>
  </>




}
