import {
    StructureType,
    TypeABCDEFGHILMPRSTUEnum,
} from '@/api/types';
import { IS_DEV } from '@/config';
import { copyTextToClipboard } from '@/utils/helpers';

import { ColCSS } from '../GridCss';
import OpsItemData from '../OpsItemData';
import { ArrayData } from './ArrayData';
import { BoolData } from './BoolData';
import { CodeData } from './CodeData';
import { ColorData } from './ColorData';
import { DateData } from './DateData';
import { EnumData } from './EnumData';
import { EnumsData } from './EnumsData';
import { FileData } from './FileData/FileData';
import { GeoPointData } from './GeoPointData/GeoPointData';
import { GeoRegionData } from './GeoRegionData/GeoRegionData';
import { GradientData } from './GradientData';
import HideData from './HideData';
import { HTMLData } from './HTMLData';
import IDData from './IDData';
import IDsData from './IDsData';
import { NumberData } from './NumberData';
import { PasswordData } from './PasswordData';
import { PhoneData } from './PhoneData';
import { RangeData } from './RangeData';
import { RateData } from './RateData';
import { StructureData } from './StructureData';
import { TextData } from './TextData';
import { TimeData } from './TimeData';
import { ItemDataProps } from './types';

export const showInAdmin = (structure: StructureType) => {
    return structure.inAdmin && !structure.hide && (structure.type != "uuid");
}

const ItemData = (props: ItemDataProps) => {



    const { hideLabel,
        collapse,
        rootParent,
        structure,
        getParentValue,
        getValue,
        setValue,
        onlyShow,
        parent,
        descriptions,
        arrayLevel, } = props;



    if (!showInAdmin(structure)) return <>


    </>;





    const InputsComponents: Partial<Record<TypeABCDEFGHILMPRSTUEnum, any>> = {

        string: TextData,
        text: TextData,
        bool: BoolData,
        float: NumberData,
        int: NumberData,

        ID: IDData,
        login: TextData,
        password: PasswordData,
        email: TextData,
        "url": TextData,
        enums: EnumsData,
        phone: PhoneData,
        'fileAudio': FileData,
        'fileDocumentLink': FileData,
        'fileDocument': FileData,
        'fileImageID': FileData,
        'fileVideoID': FileData,
        'fileAudioID': FileData,
        'fileDocumentID': FileData,
        'fileImageLink': FileData,
        'fileImage': FileData,
        'fileVideo': FileData,
        html: HTMLData,
        enum: EnumData,
        "range": RangeData,
        "unixdate": DateData,
        "unixdatetime": DateData,
        "color": ColorData,
        gradient: GradientData,
        array: ArrayData,
        structure: StructureData,
        time: TimeData,
        rate: RateData,
        geopoint: GeoPointData,
        IDs: IDsData,
        balance: NumberData,
        geoRegion: GeoRegionData,
        code: CodeData,
        //    mongoPolygon: PolygonData,
        /*    structure: StructureData,
           
            ID: IDData,
            IDs: IDsData,
           
            unixdate: DateData,
            unixdatetime: DateData,
           
          
        
    
            color: ColorData,
        
            login: TextData,
          
            time: TimeData,
            geopoint: GeoPointData,
        
          
           
            mongoPolygon: PolygonData,
        
        
            rate: RateData,
            geoRegion: GeoRegionData,
            code: CodeData,
            fileAudioLink: FileData,
          */



    };






    if (!!structure?.type) {


        if (structure.type == "action" && structure.actionPosition != "inline") {
            return <></>
        }



        if (InputsComponents[structure?.type]) {
            const RenderComponent = InputsComponents[structure?.type]

            let className = 'px-1 py-2';

            if (parent?.type == "array") {
                className = 'px-0 pb-1'
            }

            if (structure?.type == "structure" && collapse) {
                className = 'px-0 py-1'
            }




            if (RenderComponent)
                return <HideData

                    {...props}
                >
                    <ColCSS
                        className='ItemData'
                        col={structure.col ?? 24}
                    >



                        <div className={className} style={{ position: 'relative' }}>

                            {IS_DEV && <div
                                onClick={() => {

                                    copyTextToClipboard(structure.type ?? "");

                                    console.log("DEV: Copy structure", structure);
                                    console.log("DEV: PROP VALUE", props);
                                    console.log("DEV: PROP VALUE", props.getValue());
                                }}
                                className='opacity-10 hover:opacity-100 transition-opacity duration-300 cursor-pointer text-[10px] px-1 font-bold text-white absolute top-0 right-2 bg-red-500 '>{structure.key} {structure.type}</div>}

                            <RenderComponent
                                descriptions={descriptions}

                                hideLabel={hideLabel}
                                onlyShow={onlyShow}
                                arrayLevel={arrayLevel}
                                collapse={collapse}
                                parent={parent}
                                structure={structure}
                                getValue={getValue}
                                getParentValue={getParentValue}
                                setValue={setValue}
                            />



                        </div>




                    </ColCSS>
                </HideData>


        }



    }


    return <ColCSS
        col={structure.col ?? 24}
    >
        <OpsItemData
            {...props}
        />

    </ColCSS>

}

export default ItemData;