import React, {
  useEffect,
  useState,
} from 'react';

import { Star } from 'lucide-react';
import { AiFillStar } from 'react-icons/ai';

import { Button } from '@/components/ui/button';
import { Lang } from '@/lang/Lang';

import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import { ItemDataProps } from './types';

export const RateData = (props: ItemDataProps) => {


  const [localValue, setLocalValue] = useState(props.getValue());

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);



  const onChangeRate = (e: number) => {
    let val = e;
    setLocalValue(val);
  };



  if (props.onlyShow || !props.structure.editable) {

    return <div>
      <DataLabel {...props} />
      <Button variant="secondary" className='w-full flex items-center justify-between'>
        {!!localValue ? <>{localValue} <Star /></> : Lang.key('no_data_short')}
      </Button>
    </div>

  }


  return (
    <React.Fragment>
      <DataLabel {...props} />
      <div className='flex items-center gap-2'>
        {[1, 2, 3, 4, 5].map((item) => (
          <Button key={item} variant="secondary"
            onClick={() => onChangeRate(item)}
            className='w-full flex items-center justify-between'>
            <AiFillStar
              color={item <= localValue ? 'yellow' : 'gray'}
              size={22} />
          </Button>
        ))}
      </div>
      <DataDescription {...props} />

    </React.Fragment>
  );
}
