import {
  useEffect,
  useState,
} from 'react';

import _ from 'lodash';

import {
  Tabs,
  TabsContent,
  TabsList,
  TabsTrigger,
} from '@/components/ui/tabs';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { isFilled } from '@/utils/helpers';

import { RowCSS } from '../GridCss';
import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import ItemData from './ItemData';
import { ItemDataProps } from './types';

export const StructureData = (props: ItemDataProps) => {



    const { color } = useAppConfig();

    const [filled, setFilled] = useState<boolean>(false);


    useEffect(() => {


        setFilled(isFilled(props.getValue()));

    }, []);


    const getParentValue = () => {


        return props.getValue();
    }





    //Проверям нет ли группы у вложенных элементов
    const visualGroup = _.groupBy(props.structure?.items, (item) => item.group?.key);

    if (_.size(visualGroup) > 1) {



        return <Tabs className="w-[400px]">
            <TabsList>
                {_.map(visualGroup, (items, visualGroupKey) => <TabsTrigger value={visualGroupKey}>{items[0].group?.title || "Общее"}</TabsTrigger>)}

            </TabsList>

            {_.map(visualGroup, (items, visualGroupKey) => <TabsContent value={visualGroupKey}>

                <RowCSS >

                    {_.map(items, (item) => <ItemData
                        inline={props.inline}
                        getDataStructure={props.getDataStructure}
                        structureLevel={props.structureLevel + 1}
                        getDataValue={props.getDataValue}
                        rootParent={props.parent}
                        onlyShow={props.onlyShow}
                        arrayLevel={props.arrayLevel}
                        getValue={() => {

                            if (!item.key) return undefined;

                            return props.getValue()?.[item.key];

                        }}

                        getParentValue={getParentValue}


                        parent={props.structure}

                        setValue={(value: any) => {

                            if (!item.key) return;

                            props.setValue({
                                ...props.getValue(),
                                [item.key]: value
                            });
                        }}

                        structure={item}
                    />)}

                </RowCSS>

            </TabsContent>)}

        </Tabs>








    }


    return <div>

        <DataLabel {...props} />
        <DataDescription {...props} />
        <RowCSS style={{

            //   backgroundColor: colorRGBA(10),
        }}>


            {_.map(props.structure?.items, (item, key) => <ItemData


                inline={props.inline}
                descriptions={props.descriptions?.items?.[key]}

                structureLevel={props.structureLevel + 1}
                getDataStructure={props.getDataStructure}
                rootParent={props.parent}
                onlyShow={props.onlyShow}
                arrayLevel={props.arrayLevel}
                getValue={() => {

                    return props.getValue()?.[key];

                }}

                getParentValue={getParentValue}
                getDataValue={props.getDataValue}

                parent={props.structure}

                setValue={(value: any) => {
                    props.setValue({
                        ...props.getValue(),
                        [key]: value
                    });
                }}

                structure={item}
            />)}




        </RowCSS>

    </div>


};


