import { Label } from '@/components/ui/label';
import { Lang } from '@/lang/Lang';

import { ItemDataProps } from '../types';

const DataLabel = (props: ItemDataProps) => {

    if (props.hideLabel) return null;


    let title = props.structure.title ?? "";

    if (Lang.getCurrentLang() == "en" && !!props.descriptions?.titleEN) {
        title = props.descriptions.titleEN;
    }




    return <Label
        className='overflow-hidden truncate'
        required={props.structure.required}>{title}</Label>

}

export default DataLabel;