import _ from 'lodash';

import DisplayValue from '@/components/DisplayValue';
import { Badge } from '@/components/ui/badge';

import { TableItemProps } from '../TableItem';

const IDsItem = (props: TableItemProps) => {

    const value = props.value;


    if (!value || _.size(value) == 0) {
        return <div style={{
            opacity: 0.2,
        }}>{props.structure?.title}</div>
    }

    return <div>
        {_.map(value, (item, index) => {


            if (index > 4) return null;

            return <Badge><DisplayValue value={item} collection={props.structure?.collection ?? ""} /></Badge>
        })}
        {_.size(value) > 5 &&
            <Badge>
                +{_.size(value) - 5}
            </Badge>
        }
    </div>


}

export default IDsItem;