import _ from 'lodash';

import TableItem, { TableItemProps } from '../TableItem';

const StructureItem = (props: TableItemProps) => {

    const value = props.value;


    //   return <div>{props.structure?.key}</div>

    return <div className='flex flex-row gap-2'>


        {_.map(props.structure?.items, (item) => {

            if (!item.inAdmin || !item.inTable) return null;

            const valueItem = _.get(value, item?.key ?? "none", null);




            return <>
                <TableItem
                    value={valueItem}
                    structure={item ?? null}

                />
            </>

        })}




    </div>


}

export default StructureItem;