import dayjs from 'dayjs';
import _ from 'lodash';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

const UnixDateItem = (props: TableItemProps) => {

    const value = props.value;


    if (!value) return <EmptyItem {...props} />;




    return <div>
        <div>{dayjs.unix(value).format("DD.MM.YYYY")}</div>

    </div>


}

export default UnixDateItem;