import _ from 'lodash';

import {
  type StructureType,
  type TypeABCDEFGHILMPRSTUEnum,
} from '@/api/types';

import ArrayItem from './Items/ArrayItem';
import BoolItem from './Items/BoolItem';
import ColorItem from './Items/ColorItem';
import EnumItem from './Items/EnumItem';
import EnumsItem from './Items/EnumsItem';
import FileItem from './Items/FileItem';
import GeoPointItem from './Items/GeoPointItem';
import HTMLItem from './Items/HTMLItem';
import IDItem from './Items/IDItem';
import IDsItem from './Items/IDsItem';
import NumberItem from './Items/NumberItem';
import PhoneItem from './Items/PhoneItem';
import RateItem from './Items/RateItem';
import StringItem from './Items/StringItem';
import StructureItem from './Items/StructureItem';
import UnixDateItem from './Items/UnixDateItem';
import UnixDateTimeItem from './Items/UnixDateTimeItem';

export type TableItemProps = {
    value: any,
    structure: StructureType | null,
}


const TableItem = (props: TableItemProps) => {

    const renderItems: Partial<Record<TypeABCDEFGHILMPRSTUEnum, any>> = {

        "enum": EnumItem,
        "bool": BoolItem,
        'string': StringItem,
        'text': StringItem,
        'color': ColorItem,
        'int': NumberItem,
        'float': NumberItem,
        "IDs": IDsItem,
        "ID": IDItem,
        "unixdate": UnixDateItem,
        "unixdatetime": UnixDateTimeItem,
        "array": ArrayItem,
        "structure": StructureItem,
        "uuid": () => <></>,
        "html": HTMLItem,
        "phone": PhoneItem,
        "login": StringItem,
        "fileImage": FileItem,
        "fileImageLink": FileItem,
        fileImageID: FileItem,
        geopoint: GeoPointItem,
        enums: EnumsItem,
        rate: RateItem,
        url: StringItem,
        email: StringItem,


    };



    if (!!props?.structure?.type) {



        if (renderItems[props?.structure?.type]) {
            const RenderComponent = renderItems[props?.structure?.type];
            return <RenderComponent {...props} />

        }



    }




    return <div>{props.structure?.type}</div>



}

export default TableItem;