import { useAppConfig } from '@/contexts/AppConfigContext';

import CollectionTableView from './CollectionTableView';
import CollectionView from './CollectionView';

const CollectionViewStack = () => {

    const { dialogStack } = useAppConfig();


    return dialogStack.map((item) => {

        if (item.view) {
            return <CollectionView key={item.view.modalKey} {...item.view} />
        } else if (item.table) {
            return <CollectionTableView key={item.table.modalKey} {...item.table} />
        }
    })
}

export default CollectionViewStack;