import jsonLogic from 'json-logic-js';
import _ from 'lodash';
import { toJS } from 'mobx';

import { StructureType } from '@/api/types';
import { Lang } from '@/lang/Lang';

export const buttonAccess = (structure: StructureType | null | undefined, _id?: string) => {


    return {

        showCopyButton: () => {
            if (structure?.single) return false;
            return !!_id;
        },

        showCloneButton: () => {



            if (structure?.single) return false;


            return !!(!!_id && structure?.canCreate);
        },

        showRelationButton: () => {

            if (!_id) return false;
            if (structure?.single) return false;

            return true;

        },
        showActionButton: () => {

            if (structure?.single) return false;
            if (!_id) return false;

            return true;


        },

        showDeleteButton: () => {

            if (!_id) return false;
            if (structure?.single) return false;

            return structure?.canDelete ?? false;

        },
        showCreateButton: () => {
            if (structure?.single) return false;

            return structure?.canCreate ?? false;
        },
        showSaveButton: () => {

            if (!_id) {
                return structure?.canCreate ?? false;
            } else {
                return structure?.canUpdate ?? false;
            }


        },

    }


}


export const requiredValidation = (values: any, structure: StructureType, rootValue: any, prefix: string[]): string[] => {

    console.log("requiredValidation", values, structure, rootValue);
    let result: string[] = [];

    let items = structure.items;

    if (!items || _.size(items) === 0 || structure.type != 'structure') {
        items = {

            [structure.key!]: structure

        }
    }

    console.log("==>items", items);

    _.map(items, (item) => {

        if (!item.key) return;


        let localCondLogic: any[] | undefined = toJS(item.localCond);

        let hideLocalLogic = !localCondLogic ? false : !(localCondLogic.every((condition) => jsonLogic.apply(condition, toJS(values))));

        if (hideLocalLogic) {
            return;
        }



        let condLogic: any[] | undefined = toJS(item.cond);

        let hideLogic = !condLogic ? false : !(condLogic.every((condition) => jsonLogic.apply(condition, toJS(rootValue))));

        if (hideLogic) {
            return;
        }




        if (item.required) {

            if (item.type == "IDs" || item.type == "enums") {

                if (!values[item.key] || values?.[item.key]?.length === 0) {
                    result.push([...prefix, item.title ?? item.key].join(' > '));
                }

                return;

            }

            if (item.type == 'bool') {

            } if (item.type == "string" || item.type == "text" || item.type == "html") {

                if (!values[item.key] || values[item.key].trim() === "") {
                    result.push([...prefix, item.title ?? item.key].join(' > '));
                }

            } else if (values[item.key] == undefined || values[item.key] === null) {
                result.push([...prefix, item.title ?? item.key].join(' > '));
            }

        }

        if (item.itemType) {


            if (item.required && (!values[item.key] || values?.[item.key]?.length === 0)) {
                result.push(item.title ?? item.key);


            } else {

                _.map(values[item.key], (value: any, index: number) => {


                    if (!item.itemType) return;

                    let element = Lang.key('Element') + ' ' + (index + 1);
                    let rootTitle = item.title ? item.title : item.key ?? "";


                    let subResult = requiredValidation(value ?? {}, item.itemType, values, [...prefix, rootTitle, element]);
                    if (subResult.length > 0) {
                        result = [...result, ...subResult];
                    }


                });



            }


        }

        if (item.type == 'structure') {

            let subResult = requiredValidation(values[item.key] ?? {}, item, values, [...prefix, item.title ?? item.key]);
            if (subResult.length > 0) {
                result = [...result, ...subResult];
            }

        }

    });

    return result;


}