import {
    useEffect,
    useRef,
    useState,
} from 'react';

import { Trash2 } from 'lucide-react';

import { rpc } from '@/api/request';
import { DisplayValueDLOTType } from '@/api/types';
import TablePagination
    from '@/components/CollectionTable/components/TablePagination';
import { Button } from '@/components/ui/button';
import { GridRow } from '@/components/ui/grid';
import { Input } from '@/components/ui/input';
import {
    Item,
    ItemContent,
    ItemTitle,
} from '@/components/ui/item';
import { ScrollArea } from '@/components/ui/scroll-area';
import { Lang } from '@/lang/Lang';

type IDsSelectBlockProps = {
    collection: string;
    onSelect?: (id: string | null) => void;

}

const IDSelectOneBlock = ({ collection, onSelect }: IDsSelectBlockProps) => {

    const [search, setSearch] = useState<string>('');

    const timeout = useRef<any>(null);



    const [data, setData] = useState<DisplayValueDLOTType | null>(null);


    const handleSearch = () => {
        clearTimeout(timeout.current);


        timeout.current = setTimeout(() => {
            getDate();
        }, 1000);
    };
    const [loading, setLoading] = useState<boolean>(false);



    const [offset, setOffset] = useState<number>(0);

    useEffect(() => {
        getDate();
    }, [collection, offset]);

    const getDate = () => {


        setLoading(true);




        rpc.displayValues({
            collection: collection,
            offset: offset,


            search: !!search.trim() ? search.trim() : undefined,
        }).then((json) => {
            if (json?.result) {
                setData(json.result ?? null);
                setLoading(false);
            }
        }).finally(() => {
            setLoading(false);
        });

    };

    useEffect(() => {
        handleSearch();
    }, [search]);


    return <>
        <GridRow className='flex flex-row gap-0' autoSize>

            <div className='flex-1'>
                <Input
                    value={search}
                    onChange={(e) => setSearch(e.target.value)}
                    placeholder={Lang.key('search_placeholder')}
                />
            </div>

            <Button
                onClick={() => {
                    onSelect?.(null);
                }}
                size="icon"
                className='ml-1'
                variant="secondary">
                <Trash2 />
            </Button>

        </GridRow>
        <GridRow className='flex flex-col pt-2'>

            {data?.data?.map((item) => (
                <Item
                    onClick={() => {

                        onSelect?.(item._id ?? null);

                    }}
                    variant="outline">

                    <ItemContent>
                        <ItemTitle>{item.displayValue}</ItemTitle>

                    </ItemContent>

                </Item>


            ))}
        </GridRow>
        <GridRow autoSize className='flex flex-row'>
            <TablePagination
                mini={true}
                total={data?.total ?? 0}
                limit={data?.limit ?? 0}
                offset={data?.offset ?? 0}
                onChangeOffset={(offset) => {
                    setOffset(offset);
                }}
            />
        </GridRow>
    </>

    return <div>

        <div className='flex flex-row gap-0'>

            <div className='flex-1'>
                <Input
                    value={search}
                    onChange={(e) => setSearch(e.target.value)}
                    placeholder={Lang.key('search_placeholder')}
                />
            </div>

            <Button
                onClick={() => {
                    onSelect?.(null);
                }}
                size="icon"
                className='ml-1'
                variant="secondary">
                <Trash2 />
            </Button>
        </div>

        <ScrollArea
            className='pt-1'

            style={{
                height: window.innerHeight * 0.5,
                opacity: loading ? 0.5 : 1,
                pointerEvents: loading ? 'none' : 'auto',
            }}>
            {data?.data?.map((item) => (
                <Item
                    onClick={() => {

                        onSelect?.(item._id ?? null);

                    }}
                    variant="outline">

                    <ItemContent>
                        <ItemTitle>{item.displayValue}</ItemTitle>

                    </ItemContent>

                </Item>


            ))}

        </ScrollArea>
        <TablePagination
            mini={true}
            total={data?.total ?? 0}
            limit={data?.limit ?? 0}
            offset={data?.offset ?? 0}
            onChangeOffset={(offset) => {
                setOffset(offset);
            }}
        />
    </div>


}

export default IDSelectOneBlock;