import { MobileListItem } from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';

type MenuItemProps = {
    label: any;
    media: any;
    hotkey?: string;
    active?: boolean;
    onClick: () => void;
}
const MenuItem = (props: MenuItemProps) => {

    const { isMobile } = useAppConfig();

    if (isMobile) {
        return <MobileListItem
            title={props.label}
            link
            chevron={false}
            media={props.media}
            onClick={props.onClick}
        />
    }

    let className = 'flex items-center gap-2 p-2 rounded-md dark:hover:bg-gray-800 hover:bg-gray-100 cursor-pointer';
    if (props.active) {
        className += ' bg-gray-100 dark:bg-gray-800';
    }

    return <div onClick={props.onClick}
        className={className}>
        <div>
            {props.media}
        </div>
        <div className=''>
            <div className="text-sm">
                {props.label}
            </div>
        </div>
        {!!props.hotkey && <span className='text-[10px] text-gray-500'>{props.hotkey}</span>}

    </div>
}

export default MenuItem;