import * as React from 'react';

import CountryPhoneInput from 'react-phone-input-2';

import { cn } from '@/lib/utils';

function Input({ className, type, icon, ...props }: React.ComponentProps<"input"> & {
  icon?: React.ReactNode | any
  phoneInput?: boolean
}) {

  if (props.phoneInput) {
    return <CountryPhoneInput
      containerClass="!w-full phone-input-field "

      inputClass={cn(
        "!p-2 !w-full file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1 text-base shadow-xs transition-[color,box-shadow] outline-none file:inline-flex file:h-7 file:border-0 file:bg-transparent file:text-sm file:font-medium disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm",
        "focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]",
        "aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive",
        className
      )}

      //  inputClass="!w-full !h-10 !text-sm !rounded-md !border-2  !p-2"
      specialLabel={props.placeholder}
      placeholder={props.placeholder}
      value={props.value ? String(props.value) : undefined}
      onChange={(val) => {
        props.onChange?.({
          target: {
            value: val,
          },
        } as React.ChangeEvent<HTMLInputElement>);
      }}

    />
  }


  return (<div className="flex items-center">
    {icon && <div className="items-center justify-center mr-1">{icon}</div>}
    <input
      type={type}
      data-slot="input"
      className={cn(
        "file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1 text-base shadow-xs transition-[color,box-shadow] outline-none file:inline-flex file:h-7 file:border-0 file:bg-transparent file:text-sm file:font-medium disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm",
        "focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]",
        "aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive",
        className
      )}
      {...props}
    />
  </div>
  )
}

export { Input };
