import * as React from 'react';

import { Lang } from '@/lang/Lang';
import { cn } from '@/lib/utils';
import * as LabelPrimitive from '@radix-ui/react-label';

import {
  Tooltip,
  TooltipContent,
  TooltipTrigger,
} from './tooltip';

function Label({
  required = false,
  noMargin = false,
  className,
  ...props
}: React.ComponentProps<typeof LabelPrimitive.Root> & { noMargin?: boolean, required?: boolean }) {
  return (
    <div className='flex items-center'>
      <LabelPrimitive.Root
        data-slot="label"
        className={cn(
          "flex items-center gap-2 text-xs opacity-70  leading-none font-medium select-none group-data-[disabled=true]:pointer-events-none group-data-[disabled=true]:opacity-50 peer-disabled:cursor-not-allowed peer-disabled:opacity-50",
          noMargin ? '' : 'mb-1 mx-1',
          className
        )}
        {...props}
      >
        {props.children}
        {required &&
          <Tooltip>
            <TooltipTrigger asChild><span className="text-red-500">*</span></TooltipTrigger>
            <TooltipContent>
              {Lang.key('required_field')}
            </TooltipContent>
          </Tooltip>
        }
      </LabelPrimitive.Root>
    </div>
  )
}

export { Label };
