import {
  local,
  type LocalItemType,
} from './local';

export class Lang {

    public static initLang() {
        //Проверяем в localStorage текущий язык
        const currentLang = localStorage.getItem('lang');
        if (currentLang == "ru" || currentLang == "en") {
            this.setCurrentLang(currentLang);
        } else {

            //Если нет то определяем по браузерному языку
            const browserLang = navigator.language.split('-')[0];
            if (browserLang == "ru" || browserLang == "en") {
                this.setCurrentLang(browserLang);
            } else {
                this.setCurrentLang("en");
            }

        }
    }

    private static currentLang: "ru" | "en" = 'ru';
    private static pendingKeys = new Set<string>();

    public static getCurrentLang() {
        return this.currentLang;
    }

    public static manualChangeLang(lang: "ru" | "en") {
        this.setCurrentLang(lang);
        window.location.reload();
    }

    public static setCurrentLang(lang: "ru" | "en") {
        this.currentLang = lang;
        localStorage.setItem('lang', lang);
    }

    private static async addKeyToLocal(key: string) {
        // Предотвращаем множественные запросы для одного ключа
        if (this.pendingKeys.has(key)) {
            return;
        }
        this.pendingKeys.add(key);

        // В dev режиме отправляем запрос на сервер для добавления ключа
        if (import.meta.env.DEV) {
            try {
                await fetch('/api/add-lang-key', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ key }),
                });
            } catch (error) {
                console.warn(`Не удалось добавить ключ "${key}" в local.ts:`, error);
            } finally {
                this.pendingKeys.delete(key);
            }
        }
    }

    public static key(key: string) {

        let value: LocalItemType = local?.[key];

        if (!value) {
            // В dev режиме пытаемся добавить ключ в local.ts
            if (import.meta.env.DEV) {
                this.addKeyToLocal(key);
            }
            return key;
        }

        return value[this.currentLang];


    }


}