

export type LangType = 'ru' | 'en';
export type LocalType = {
    [key: string]: LocalItemType
}

export type LocalItemType = {
    ru: string;
    en: string;
}

export const local: LocalType = {

    'login': {
        ru: "Вход",
        en: "Login",
    },
    'registration': {
        ru: "Регистрация",
        en: "Registration",
    },
    'recovery': {
        ru: "Восстановление пароля",
        en: "Password recovery",
    },
    'restore': {
        ru: "Восстановление доступа",
        en: "Restore access",
    },
    'enterPassword': {
        ru: "Ввести пароль",
        en: "Enter password",
    },
    'phoneLogin': {
        ru: "Вход по номеру телефона",
        en: "Phone login",
    },
    'continue': {
        ru: "Продолжить",
        en: "Continue",
    },
    'forgotPassword': {
        ru: "Забыл пароль?",
        en: "Forgot password?",
    },
    'or': {
        ru: "или",
        en: "or",
    },
    'emailOrLogin': {
        ru: "Почта или логин",
        en: "Email or login",
    },
    'termsOfUse': {
        ru: "При входе на ресурс вы принимаете",
        en: "By entering the resource, you accept",
    },
    'termsOfUseLink': {
        ru: "условия использования",
        en: "terms of use",
    },
    'and': {
        ru: "и",
        en: "and",
    },
    'privacyPolicyLink': {
        ru: "обработку персональных данных",
        en: "processing of personal data",
    },
    "emailCodeConfirmationSentToEmail": {
        ru: "Код подтверждения отправлен на почту",
        en: "Code confirmation sent to email",
    },
    'emailCodeConfirmation': {
        ru: "Код подтверждения",
        en: "Code confirmation",
    },
    'password': {
        ru: "Пароль",
        en: "Password",
    },
    'emailCodeConfirmationSent': {
        ru: "Код подтверждения отправлен на почту",
        en: "Code confirmation sent to email",
    },
    'copyCode': {
        ru: "Скопировать код",
        en: "Copy code",
    },
    'selectMessenger': {
        ru: "Выберите мессенджер",
        en: "Select messenger",
    },
    'autoLogin': {
        ru: "Отправить код в мессенджер",
        en: "Send code to messenger",
    },
    'scanQRCode': {
        ru: "Сканируйте QR-код камерой телефона, чтобы перейти к выбранному мессенджеру",
        en: "Scan QR code with your phone to go to the selected messenger",
    },
    'copiedToClipboard': {
        ru: "Скопировано в буфер обмена",
        en: "Copied to clipboard",
    },
    'enterPhoneLogin': {
        ru: "Введите номер телефона",
        en: "Enter phone number",
    },
    'phone': {
        ru: "Номер телефона",
        en: "Phone number",
    },
    'successfulAuthorization': {
        ru: "Успешный вход",
        en: "Successful authorization",
    },
    'searchPlaceholder': {
        ru: "Поиск",
        en: "Search",
    },
    'total': {
        ru: "Всего",
        en: "Total",
    },
    'page': {
        ru: "Страница",
        en: "Page",
    },
    'empty_table_title': {
        ru: "Нет данных",
        en: "No data",
    },
    'empty_table_description': {
        ru: "Нет данных доступных для отображения",
        en: "No data available for display",
    },
    'empty_table_button_create': {
        ru: "Создать",
        en: "Create",
    },
    'empty_table_button_clean_filter': {
        ru: "Очистить фильтры",
        en: "Clean filters",
    },
    'select_value': {
        ru: "Выберите значение",
        en: "Select value",
    },
    'search': {
        ru: "Поиск",
        en: "Search",
    },
    'no_results_found': {
        ru: "Ничего не найдено",
        en: "Nothing found",
    },
    'set_password': {
        ru: "Установить пароль",
        en: "Set password",
    },
    'generate_random_password': {
        ru: "Сгенерировать случайный пароль",
        en: "Generate random password",
    },
    'close': {
        ru: "Закрыть",
        en: "Close",
    },
    'new_password': {
        ru: "Новый пароль",
        en: "New password",
    },
    'file_browse': {
        ru: "Выбрать файл",
        en: "Browse file",
    },
    'file_drag_drop': {
        ru: "Перетащите файлы сюда",
        en: "Drag and drop files here",
    },
    'file_rejected': {
        ru: "Файл не принят",
        en: "File not accepted",
    },
    'click_to_browse_file': {
        ru: "Нажмите для выбора файла",
        en: "Click to browse file",
    },
    'file_type_not_allowed': {
        ru: "Тип файла не разрешен",
        en: "File type not allowed",
    },
    'file_size_max': {
        ru: "Размер файла превышает максимальный размер",
        en: "File size exceeds the maximum size",
    },
    'from': {
        ru: "От",
        en: "From",
    },
    'to': {
        ru: "До",
        en: "To",
    },
    'select_date': {
        ru: "Выберите дату",
        en: "Select date",
    },
    'select_time': {
        ru: "Выберите время",
        en: "Select time",
    },
    'pick_color': {
        ru: "Выберите цвет",
        en: "Select color",
    },
    'reset': {
        ru: "Сбросить",
        en: "Reset",
    },
    'add_color': {
        ru: "Добавить цвет",
        en: "Add color",
    },
    'min_colors_gradient': {
        ru: "Минимальное количество цветов в градиенте 2",
        en: "Minimum number of colors in gradient 2",
    },
    'enabled_float_number': {
        ru: "Допустимо число с дробной частью",
        en: "Allowed number with fractional part",
    },
    'only_int_number': {
        ru: "Только целое число",
        en: "Only integer number",
    },
    'required_field': {
        ru: "Обязательное поле",
        en: "Required field",
    },
    'add_to': {
        ru: "Добавить в",
        en: "Add to",
    },
    'delete_all': {
        ru: "Удалить все",
        en: "Delete all",
    },
    'sort': {
        ru: "Сортировка",
        en: "Sort",
    },
    'add': {
        ru: "Добавить",
        en: "Add",
    },
    'cant_move_up': {
        ru: "Невозможно переместить вверх",
        en: "Cannot move up",
    },
    'cant_move_down': {
        ru: "Невозможно переместить вниз",
        en: "Cannot move down",
    },
    'no_data_short': {
        ru: "Не задано",
        en: "Not set",
    },
    'save': {
        ru: "Сохранить",
        en: "Save",
    },
    'copy': {
        ru: "Скопировать",
        en: "Copy",
    },
    'delete': {
        ru: "Удалить",
        en: "Delete",
    },
    'save_and_close': {
        ru: "Сохранить и закрыть",
        en: "Save and close",
    },
    'save_and_add_new': {
        ru: "Сохранить и добавить новый",
        en: "Save and add new",
    },
    'save_and_edit': {
        ru: "Сохранить и продолжить",
        en: "Save and continue",
    },
    'copy_item_id': {
        ru: "Скопировать ID",
        en: "Copy ID",
    },
    'copy_item': {
        ru: "Создать копию",
        en: "Create copy",
    },
    'start_entering_an_address_for_a_search_to_go_to_the_editing_mode_click_on_enable_editing_mode': {
        ru: "Для перехода в режим редактирования нажмите на кнопку \"Включить режим редактирования\"",
        en: "To go to the editing mode, click on the \"Enable editing mode\" button",
    },
    'enable_editing_mode': {
        ru: "Включить режим редактирования",
        en: "Enable editing mode",
    },
    'add_comment': {
        ru: "Добавить комментарий",
        en: "Add comment",
    },
    'add_entrance': {
        ru: "Добавить подъезд",
        en: "Add entrance",
    },
    'add_floor': {
        ru: "Добавить этаж",
        en: "Add floor",
    },
    'add_apartment': {
        ru: "Добавить квартиру",
        en: "Add apartment",
    },
    'add_phone': {
        ru: "Добавить телефон",
        en: "Add phone",
    },
    'remove_comment': {
        ru: "Убрать комментарий",
        en: "Remove comment",
    },
    'remove_entrance': {
        ru: "Убрать подъезд",
        en: "Remove entrance",
    },
    'remove_floor': {
        ru: "Убрать этаж",
        en: "Remove floor",
    },
    'remove_apartment': {
        ru: "Убрать квартиру",
        en: "Remove apartment",
    },
    'remove_phone': {
        ru: "Убрать телефон",
        en: "Remove phone",
    },
    'you_can_edit_address_in_free_mode_to_go_to_search_mode_click_on_enable_search_mode': {
        ru: "Вы можете редактировать адрес в режиме свободного ввода, чтобы перейти в режим поиска, нажмите на кнопку \"Включить режим поиска\"",
        en: "You can edit the address in the free mode to go to the search mode, click on the \"Enable search mode\" button",
    },
    'enable_search_mode': {
        ru: "Включить режим поиска",
        en: "Enable search mode",
    },
    'search_address_placeholder': {
        ru: "Введите адрес",
        en: "Enter address",
    },
    'address': {
        ru: "Адрес",
        en: "Address",
    },
    'entrance': {
        ru: "Подъезд",
        en: "Entrance",
    },
    'floor': {
        ru: "Этаж",
        en: "Floor",
    },
    'apartment': {
        ru: "Квартира",
        en: "Apartment",
    },
    'comment': {
        ru: "Комментарий",
        en: "Comment",
    },
    'searching': {
        ru: "Поиск...",
        en: "Searching...",
    },
    'click_on_map_to_select_location': {
        ru: "Нажмите на карте для выбора местоположения",
        en: "Click on the map to select the location",
    },
    'selected': {
        ru: "Выбрано",
        en: "Selected",
    },
    'delete_selected': {
        ru: "Удалить выбранные",
        en: "Delete selected",
    },
    'edit_fields': {
        ru: "Редактировать поля",
        en: "Edit fields",
    },
    'do_action': {
        ru: "Выполнить действие",
        en: "Do action",
    },
    'saving': {
        ru: "Сохранение...",
        en: "Saving...",
    },
    'saved_successfully': {
        ru: "Сохранено успешно",
        en: "Saved successfully",
    },
    'select_audio': {
        ru: "Загрузить аудио",
        en: "Upload audio",
    },
    'select_document': {
        ru: "Загрузить документ",
        en: "Upload document",
    },
    'select_video': {
        ru: "Загрузить видео",
        en: "Upload video",
    },
    'select_image': {
        ru: "Загрузить изображение",
        en: "Upload image",
    },
    'select_file': {
        ru: "Загрузить файл",
        en: "Upload file",
    },
    'uploading_file_wait': {
        ru: "Загрузка файла...",
        en: "Uploading file...",
    },
    'upload_new': {
        ru: "Загрузить новый файл",
        en: "Upload new file",
    },
    'copy_link': {
        ru: "Скопировать ссылку",
        en: "Copy link",
    },
    'delete_item': {
        ru: "Удалить запись?",
        en: "Delete record?",
    },
    'delete_item_description': {
        ru: "Вы уверены, что хотите удалить эту запись?",
        en: "Are you sure you want to delete this record?",
    },
    'cancel': {
        ru: "Отмена",
        en: "Cancel",
    },
    'deleted_successfully': {
        ru: "Запись удалена успешно",
        en: "Record deleted successfully",
    },
    'error_saving': {
        ru: "Ошибка сохранения",
        en: "Error saving",
    },
    'error_deleting': {
        ru: "Ошибка удаления",
        en: "Error deleting",
    },
    'record_audio': {
        ru: "Записать аудио",
        en: "Record audio",
    },
    'start_recording_stop_listen_apply': {
        ru: "Начните запись, после завершения нажмите на кнопку \"Остановить запись\". Вы можете прослушать запись и перезаписать её, после чего нажмите на кнопку \"Сохранить\"",
        en: "Start recording, then click \"Stop recording\". You can listen to the recording and re-record it, then click \"Save\"."
    },
    'start_recording': {
        ru: "Начать запись",
        en: "Start recording",
    },
    'stop_recording': {
        ru: "Остановить запись",
        en: "Stop recording",
    },
    'recording_in_progress': {
        ru: "Идёт запись...",
        en: "Recording in progress...",
    },
    'rerecord': {
        ru: "Перезаписать",
        en: "Rerecord",
    },
    'recording_audio_not_supported_in_this_browser': {
        ru: "Запись аудио не поддерживается в этом браузере.",
        en: "Recording audio not supported in this browser.",
    },
    'my_account': {
        ru: "Моя учетная запись",
        en: "My account",
    },
    'profile': {
        ru: "Профиль",
        en: "Profile",
    },
    'billing': {
        ru: "Платежи",
        en: "Billing",
    },
    'log_out': {
        ru: "Выйти",
        en: "Log out",
    },
    'log_out_description': {
        ru: "Вы уверены, что хотите выйти из учетной записи?",
        en: "Are you sure you want to log out of your account?",
    },
    'log_out_title': {
        ru: "Выход из учетной записи",
        en: "Log out of account",
    },
    'add_filter': {
        ru: "Добавить фильтр",
        en: "Add filter",
    },
    'search_fields': {
        ru: "Поиск полей",
        en: "Search fields",
    },
    'no_fields_found': {
        ru: "Поля не найдены",
        en: "Fields not found",
    },
    'select': {
        ru: "Выбрать",
        en: "Select",
    },
    'true': {
        ru: "Да",
        en: "Yes",
    },
    'false': {
        ru: "Нет",
        en: "No",
    },
    'min': {
        ru: "Минимальное значение",
        en: "Minimum value",
    },
    'max': {
        ru: "Максимальное значение",
        en: "Maximum value",
    },
    'type_and_press_enter_to_add_tag': {
        ru: "Введите и нажмите Enter для добавления тега",
        en: "Enter and press Enter to add a tag",
    },
    'selected_count': {
        ru: "Выбрано",
        en: "Selected",
    },
    'percent': {
        ru: "Процент",
        en: "Percent",
    },
    'default_currency': {
        ru: "Валюта по умолчанию",
        en: "Default currency",
    },
    'default_color': {
        ru: "Цвет по умолчанию",
        en: "Default color",
    },
    'add_filter_title': {
        ru: "Добавить фильтр",
        en: "Add filter",
    },
    'enter_key': {
        ru: "Введите ключ",
        en: "Enter key",
    },
    'enter_value': {
        ru: "Введите значение",
        en: "Enter value",
    },
    'invalid_email_format': {
        ru: "Неверный формат email",
        en: "Invalid email format",
    },
    'invalid_url_format': {
        ru: "Неверный формат URL",
        en: "Invalid URL format",
    },
    'invalid_phone_format': {
        ru: "Неверный формат телефона",
        en: "Invalid phone format",
    },
    'invalid_input_format': {
        ru: "Неверный формат ввода",
        en: "Invalid input format",
    },
    'filter_operator_is': {
        ru: "Равно",
        en: "Equal",
    },
    'filter_operator_is_not': {
        ru: "Не равно",
        en: "Not equal",
    },
    'filter_operator_after': {
        ru: "После",
        en: "After",
    },
    'filter_operator_before': {
        ru: "До",
        en: "Before",
    },
    'filter_operator_is_any_of': {
        ru: "Любое из",
        en: "Any of",
    },
    'filter_operator_between': {
        ru: "Между",
        en: "Between",
    },
    'filter_operator_not_between': {
        ru: "Не между",
        en: "Not between",
    },
    'filter_operator_is_not_any_of': {
        ru: "Не любое из",
        en: "Not any of",
    },
    'filter_operator_not_contains': {
        ru: "Не содержит",
        en: "Not contains",
    },
    'filter_operator_starts_with': {
        ru: "Начинается с",
        en: "Starts with",
    },
    'filter_operator_contains': {
        ru: "Содержит",
        en: "Contains",
    },
    'filter_operator_includes_all': {
        ru: "Включает все",
        en: "Includes all",
    },
    'filter_operator_is_exactly': {
        ru: "Точно соответствует",
        en: "Exactly matches",
    },
    'filter_operator_equals': {
        ru: "Равно",
        en: "Equal",
    },
    'filter_operator_not_equals': {
        ru: "Не равно",
        en: "Not equal",
    },
    'filter_operator_ends_with': {
        ru: "Заканчивается на",
        en: "Ends with",
    },
    'filter_operator_excludes_all': {
        ru: "Не включает все",
        en: "Does not include all",
    },
    'filter_operator_less_than': {
        ru: "Меньше",
        en: "Less than",
    },
    'filter_operator_overlaps': {
        ru: "Пересекается",
        en: "Overlaps",
    },
    'filter_operator_includes': {
        ru: "Включает",
        en: "Includes",
    },
    'filter_operator_excludes': {
        ru: "Не включает",
        en: "Does not include",
    },
    'filter_operator_greater_than': {
        ru: "Больше",
        en: "Greater than",
    },
    'filter_operator_includes_any_of': {
        ru: "Включает любое из",
        en: "Includes any of",
    },
    'filter_operator_empty': {
        ru: "Пусто",
        en: "Empty",
    },
    'filter_operator_not_empty': {
        ru: "Не пусто",
        en: "Not empty",
    },
    'filter_operator_includes_all_of': {
        ru: "Включает все",
        en: "Includes all",
    },
    'saving_profile': {
        ru: "Сохранение профиля...",
        en: "Saving profile...",
    },
    'profile_saved_successfully': {
        ru: "Профиль сохранен успешно",
        en: "Profile saved successfully",
    },
    'error_saving_profile': {
        ru: "Ошибка сохранения профиля",
        en: "Error saving profile",
    },
    'change_password': {
        ru: "Изменить пароль",
        en: "Change password",
    },
    'save_new_password': {
        ru: "Сохранить новый пароль",
        en: "Save new password",
    },
    'new_password_saved_successfully': {
        ru: "Новый пароль сохранен успешно",
        en: "New password saved successfully",
    },
    'error_saving_new_password': {
        ru: "Ошибка сохранения нового пароля",
        en: "Error saving new password",
    },
    'search_placeholder': {
        ru: "Поиск...",
        en: "Search...",
    },
    'invalidLoginOrEmail': {
        ru: "Неверный логин или email",
        en: "Invalid login or email",
    },
    'Enter': {
        ru: "Введите",
        en: "Enter",
    },
    'filter': {
        ru: "Фильтр",
        en: "Filter",
    },
    'select_filter': {
        ru: "Выберите фильтр",
        en: "Select filter",
    },
    'Yes': {
        ru: "Да",
        en: "Yes",
    },
    'No': {
        ru: "Нет",
        en: "No",
    },

    'select_operator': {
        ru: "Выберите оператор",
        en: "Select operator",
    },
    'greater_than': {
        ru: "Больше чем",
        en: "Greater than",
    },
    'less_than': {
        ru: "Меньше чем",
        en: "Less than",
    },
    'between': {
        ru: "Между",
        en: "Between",
    },
    'select_value_address': {
        ru: "Выберите адрес",
        en: "Select address",
    },
    'export': {
        ru: "Экспорт",
        en: "Export",
    },
    'create': {
        ru: "Создать",
        en: "Create",
    },
    'sortingByHandSuccess': {
        ru: "Сортировка успешно сохранена",
        en: "Sorting saved successfully",
    },
    'sortingByHandError': {
        ru: "Ошибка сохранения сортировки",
        en: "Error saving sorting",
    },
    'sortingByHandDisabledWithManualSort': {
        ru: "Сортировка по столбцам отключена при ручной сортировке",
        en: "Column sorting is disabled when manual sorting is enabled",
    },
    'disableManualSort': {
        ru: "Отключить ручную сортировку",
        en: "Disable manual sorting",
    },
    'manualSort': {
        ru: "Ручная сортировка",
        en: "Manual sorting",
    },
    'date': {
        ru: "Дата",
        en: "Date",
    },
    'time': {
        ru: "Время",
        en: "Time",
    },
    'Element': {
        ru: "Элемент",
        en: "Element",
    },
    'is_required': {
        ru: "обязательное поле",
        en: "is required",
    },
    'exportCreatedSuccess': {
        ru: "Экспорт создан, вы сможете скачать его в разделе Экспорт данных, когда он будет готов.",
        en: "Export created, you will be able to download it in the Export data section when it is ready.",
    },
    'export_data': {
        ru: "Экспорт данных",
        en: "Export data",
    },
    'no_export_data': {
        ru: "У вас нет экспортов",
        en: "You have no exports",
    },
    'no_export_data_description': {
        ru: "После создания экспорта здесь вы сможете отслеживать его статус и скачать результат",
        en: "After creating an export, here you can track its status and download the result",
    },
    'export_data_pending': {
        ru: "Подготовка данных",
        en: "Preparing data",
    },
    'export_data_processing': {
        ru: "Формирование файла",
        en: "Generating file",
    },
    'export_data_done': {
        ru: "Файл готов",
        en: "File is ready",
    },
    'export_data_error': {
        ru: "Ошибка экспорта",
        en: "Error exporting",
    },
    'export_data_confirm': {
        ru: "Подтверждение экспорта",
        en: "Export confirmation",
    },
    'export_data_confirm_description': {
        ru: "Вы уверены, что хотите экспортировать данные?",
        en: "Are you sure you want to export data?",
    },
    'payment': {
        ru: "Операция",
        en: "Operation",
    },
    'payment_history': {
        ru: "Детализация платежей и списаний",
        en: "Payment history",
    },
    'payment_history_description_one': {
        ru: "Списание средств за услуги производится со счетов, образованных в порядке поступления платежей.",
        en: "The withdrawal of funds for services is made from accounts formed in the order of payment inflow.",
    },
    'payment_history_description_two': {
        ru: "В случае достижения отрицательного баланса лицевого счета долговые списания покрываются следующим поступлением.",
        en: "In case of reaching a negative balance of the account, debt deductions are covered by the next inflow.",
    },
    'payment_and_balance': {
        ru: "Платежи и баланс",
        en: "Payments and balance",
    },
    'spend_balance': {
        ru: "Списание с баланса",
        en: "Spend from balance",
    },
    'earn_balance': {
        ru: "Зачисление на баланс",
        en: "Earn on balance",
    },
    'all_operations': {
        ru: "Все операции",
        en: "All operations",
    },
    'payment_type': {
        ru: "Тип операции",
        en: "Operation type",
    },
    'payment_description': {
        ru: "Назначение",
        en: "Details",
    },
    'payment_amount': {
        ru: "Сумма",
        en: "Amount",
    },
    'payment_currency': {
        ru: "Валюта",
        en: "Currency",
    },
    'payment_earn': {
        ru: "Зачисление",
        en: "Earn",
    },
    'not_found_payment': {
        ru: "Операций по балансу не найдено",
        en: "No operations found for balance",
    },
    'top_up_balance': {
        ru: "Пополнить",
        en: "Top up",
    },
    'export_report': {
        ru: "Скачать ведомость расчетов",
        en: "Download payment report",
    },
    'no_gateways_available': {
        ru: "Онлайн оплата сейчас не доступна",
        en: "Online payment is not available",
    },
    'no_gateways_available_description': {
        ru: "Сейчас вы не можете пополнить баланс онлайн, для пополнения обратитесь в поддержку или к вашему менеджеру.",
        en: "You cannot top up the balance online, for top up contact support or your manager.",
    },
    'exporting_report': {
        ru: "Формирование ведомости расчетов...",
        en: "Generating payment report...",
    },
    'report_exported_successfully': {
        ru: "Ведомость расчетов успешно сформирована, вы сможете скачать его в разделе Экспорт данных, когда он будет готов.",
        en: "Payment report successfully generated, you will be able to download it in the Export data section when it is ready.",
    },
    'error_exporting_report': {
        ru: "Ошибка формирования ведомости расчетов",
        en: "Error generating payment report",
    },
    'edit_item': {
        ru: "Редактирование",
        en: "Edit",
    },
    'create_item': {
        ru: "Создание",
        en: "Create new",
    },
    'calendar_su_sort': {
        ru: "Вск",
        en: "Su",
    },
    'calendar_mo_sort': {
        ru: "Пн",
        en: "Mo",
    },
    'calendar_sa_sort': {
        ru: "Сб",
        en: "Sa",
    },
    'calendar_tu_sort': {
        ru: "Вт",
        en: "Tu",
    },
    'calendar_we_sort': {
        ru: "Ср",
        en: "We",
    },
    'calendar_th_sort': {
        ru: "Чт",
        en: "Th",
    },
    'calendar_fr_sort': {
        ru: "Пт",
        en: "Fr",
    },
    'all': {
        ru: "Все",
        en: "All",
    },
    'remove_selected': {
        ru: "Удалить выбранные",
        en: "Remove selected",
    },
    'add_selected': {
        ru: "Добавить выбранные",
        en: "Add selected",
    },
    'confirm_ids_selection': {
        ru: "Сохранить выбор",
        en: "Save selection",
    },
    'confirm_ids_selection_description': {
        ru: "Сохранить выбранные элементы?",
        en: "Save selected items?",
    },
    'items': {
        ru: "Элементы",
        en: "Items",
    },
    'remove_selected_items': {
        ru: "Удалить выбранные элементы?",
        en: "Delete selected items?",
    },
    'remove_selected_items_description': {
        ru: "Вы уверены, что хотите удалить выбранные элементы? Это действие нельзя будет отменить.",
        en: "Are you sure you want to delete selected items? This action cannot be undone.",
    },
    'removing_selected_items': {
        ru: "Удаление выбранных элементов...",
        en: "Removing selected items...",
    },
    'remove_selected_items_success': {
        ru: "Выбранные элементы удалены успешно",
        en: "Selected items deleted successfully",
    },
    'add_from_excel': {
        ru: "Добавить из Excel",
        en: "Add from Excel",
    },
    'import_from_excel': {
        ru: "Импорт из Excel",
        en: "Import from Excel",
    },
    'select_excel_file': {
        ru: "Выберите файл Excel",
        en: "Select Excel file",
    },
    'import_from_excel_description_one': {
        ru: "Выберите файл Excel для импорта данных, первый столбец будет использоваться как значение",
        en: "Select an Excel file to import data, the first column will be used as the value",
    },

    'vkLogin': {
        ru: "VK",
        en: "VK",
    },
    'yaLogin': {
        ru: "Яндекс",
        en: "Yandex",
    },
    'googleLogin': {
        ru: "Google",
        en: "Google",
    },
    'loginWithAuth4AppInstructions': {
        ru: "Для входа по номеру телефона, скопируйте код и отправьте его в один из мессенджеров. Вход будет произведен автоматически после отправки кода.",
        en: "To login by phone number, copy the code and send it to one of the messengers. Login will be performed automatically after sending the code.",
    },

    'selectMessengerAndSendCodeToMessenger': {
        ru: "Выберите мессенджер и отправьте код в него",
        en: "Select messenger and send code to it",
    },
    'cancelAuthWithPhoneNumber': {
        ru: "Отменить вход по номеру телефона",
        en: "Cancel login by phone number",
    },
    'enter_new_password': {
        ru: "Введите новый пароль",
        en: "Enter new password",
    },

    'payment_spend': {
        ru: "Списание",
        en: "Spend",
    },
    'export_selected': {
        ru: "Экспортировать выбранные",
        en: "Export selected",
    },
    'export_selected_items': {
        ru: "Экспортировать выбранные элементы?",
        en: "Export selected items?",
    },
    'export_selected_items_description': {
        ru: "Вы уверены, что хотите экспортировать выбранные элементы?",
        en: "Are you sure you want to export selected items?",
    },
    'apply': {
        ru: "Применить",
        en: "Apply",
    },
    'clearFilter': {
        ru: "Очистить фильтры",
        en: "Clear filters",
    },
    'please_add_filter': {
        ru: "Пожалуйста, добавьте фильтр",
        en: "Please add a filter",
    },
    'no_filters_title': {
        ru: "Фильтры не заданы",
        en: "Filters not set",
    },
    'no_filters_description': {
        ru: "Нажмите на кнопку добавить фильтр для добавления фильтра",
        en: "Click the add filter button to add a filter",
    },
    'clear_all': {
        ru: "Очистить все",
        en: "Clear all",
    },
    'edit': {
        ru: "Редактировать",
        en: "Edit",
    },
    'click_to_set_location': {
        ru: "Нажмите для установки местоположения",
        en: "Click to set location",
    },
    'error_please_go_to_support': {
        ru: "Упс! Кажется, что-то пошло не так, обратитесь в поддержку",
        en: "Oops! Something went wrong, please contact support",
    },
    'region_editor': {
        ru: "Редактор региона",
        en: "Region editor",
    },
    'edit_field': {
        ru: "Редактировать поле",
        en: "Edit field",
    },
    'remove_item': {
        ru: "Удалить элемент?",
        en: "Delete item?",
    },
    'remove_item_description': {
        ru: "Вы уверены, что хотите удалить элемент? Это действие нельзя будет отменить.",
        en: "Are you sure you want to delete the item? This action cannot be undone.",
    },
    'actions': {
        ru: "Действия",
        en: "Actions",
    },
    'execute': {
        ru: "Выполнить",
        en: "Execute",
    },
    'open_link': {
        ru: "Открыть ссылку",
        en: "Open link",
    },
    'executing': {
        ru: "Выполнение...",
        en: "Executing...",
    },
    'action_dialog_success_title': {
        ru: "Действие выполнено успешно",
        en: "Action executed successfully",
    },
    'hide_tips': {
        ru: "Скрыть подсказки",
        en: "Hide tips",
    },
    'show_tips': {
        ru: "Показать подсказки",
        en: "Show tips",
    },
    'run_action_confirm': {
        ru: "Вы уверены, что хотите выполнить действие?",
        en: "Are you sure you want to run the action?",
    },
    'dark_theme': {
        ru: "Темная тема",
        en: "Dark theme",
    },
    'light_theme': {
        ru: "Светлая тема",
        en: "Light theme",
    },
    'internet_error_navbar_title': {
        ru: "Проблемы с соединением",
        en: "Connection Issues",
    },
    'internet_error_card_header': {
        ru: "Нет соединения с сервером 😴",
        en: "No connection to server 😴",
    },
    'internet_error_card_description': {
        ru: "Соединение с сервером прервано или сервер временно недоступен. Проверьте ваше интернет-соединение и попробуйте обновить страницу через несколько секунд.",
        en: "Connection to the server was interrupted or the server is temporarily unavailable. Check your internet connection and try refreshing the page in a few seconds.",
    },
    'internet_error_card_button': {
        ru: "Попробовать снова",
        en: "Try Again",
    },
    'relations_collection': {
        ru: "Связанные данные",
        en: "Related data",
    },

    'select_block_type': {
        ru: "Выберите тип блока",
        en: "Select block type",
    },

    'bi_block_type_chart_name': {
        ru: "График",
        en: "Chart",
    },
    'bi_block_type_chart_description': {
        ru: "Визуализация данных в виде линии для отображения значений показателя.",
        en: "Visualization of data as a line to display the values of the indicator.",
    },
    'bi_block_type_square_name': {
        ru: "Карточка показателя",
        en: "Indicator card",
    },
    'bi_block_type_pie_name': {
        ru: "Круговая диаграмма",
        en: "Pie chart",
    },
    'bi_block_type_funnel_name': {
        ru: "Воронка",
        en: "Funnel",
    },
    'bi_block_type_square_description': {
        ru: "Отображает одно агрегированное числовое значение показателя.",
        en: "Displays a single aggregated numerical value of the indicator.",
    },
    'bi_block_type_pie_description': {
        ru: "Визуализация распределения значений по категориям в виде секторов круга.",
        en: "Visualization of the distribution of values by categories in the form of sectors of a circle.",
    },
    'bi_block_type_abc_name': {
        ru: "ABC анализ",
        en: "ABC analysis",
    },
    'bi_block_type_abc_description': {
        ru: "Анализ ABC - классификация значений по частоте появления в данных.",
        en: "ABC analysis - classification of values by frequency of occurrence in data.",
    },
    'bi_block_type_funnel_description': {
        ru: "Визуализация распределения значений по категориям в виде воронки.",
        en: "Visualization of the distribution of values by categories in the form of a funnel.",
    },
    'bi_block_type_table_name': {
        ru: "Таблица",
        en: "Table",
    },
    'bi_block_type_xyz_description': {
        ru: "Визуализация распределения значений по категориям в виде XYZ анализа.",
        en: "Visualization of the distribution of values by categories in the form of XYZ analysis.",
    },
    'bi_block_type_xyz_name': {
        ru: "XYZ анализ",
        en: "XYZ analysis",
    },
    'bi_block_type_table_description': {
        ru: "Визуализация данных в виде таблицы.",
        en: "Visualization of data as a table.",
    },
    'bi_view': {
        ru: "Аналитика",
        en: "Analytics",
    },
    'add_bi_view_board': {
        ru: "Добавить доску аналитики",
        en: "Add analytics board",
    },
    'add_bi_view_block': {
        ru: "Добавить блок",
        en: "Add block",
    },
    'delete_bi_view_block': {
        ru: "Удалить блок?",
        en: "Delete block?",
    },
    'delete_bi_view_block_description': {
        ru: "Вы уверены, что хотите удалить блок? Это действие нельзя будет отменить.",
        en: "Are you sure you want to delete the block? This action cannot be undone.",
    },
}