import React from 'react';

import { LuCopy } from 'react-icons/lu';
import QRCode from 'react-qr-code';

import { ShmMsgAuthType } from '@/api/types';
import {
    MobileBlock,
    MobileButton,
    MobileList,
    MobileListItem,
    MobileSheet,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';
import { copyTextToClipboard } from '@/utils/helpers';

const LoginAuth4App = ({ msgAuthData, onCancelAuthWithPhoneNumber }: { msgAuthData: ShmMsgAuthType, onCancelAuthWithPhoneNumber?: () => void }) => {

    const { isMobile } = useAppConfig();


    if (isMobile) {
        return <>
            <MobileSheet
                className="pb-safe"
                opened
            >


                <div className='my-2  px-2 mt-6 text-sm text-gray-500 text-center '>{Lang.key('loginWithAuth4AppInstructions')}</div>

                <MobileList outline>
                    <MobileListItem
                        dividers
                        media={<LuCopy />}
                        title={msgAuthData?.code}
                        footer={Lang.key('copyCode')}
                        onClick={() => {
                            copyTextToClipboard(msgAuthData?.code?.toString() ?? '');
                        }}
                    ></MobileListItem>



                </MobileList>

                <div className='px-2 text-sm text-gray-500 text-center'>
                    {Lang.key('selectMessengerAndSendCodeToMessenger')}
                </div>
                <MobileBlock outline>
                    <div className="flex items-center justify-around ">
                        {msgAuthData?.links?.map((val) => {
                            return (
                                <div
                                    onClick={() => {
                                        window.open(val.link);
                                    }}
                                >
                                    <img
                                        className="w-12 h-12 rounded-lg cursor-pointer active:opacity-50"
                                        src={val.image}
                                    />
                                </div>
                            );
                        })}
                    </div>
                </MobileBlock>

                <MobileBlock>
                    <MobileButton
                        onClick={() => {
                            onCancelAuthWithPhoneNumber?.();
                        }}
                    >
                        {Lang.key('cancelAuthWithPhoneNumber')}
                    </MobileButton>
                </MobileBlock>

            </MobileSheet>
        </>
    }

    return <>

        <div className='my-2  px-2 mt-6 text-sm text-gray-500 '>{Lang.key('loginWithAuth4AppInstructions')}</div>
        <div className="my-2  px-2 mt-6">
            <span className='text-xl font-bold'>1. </span>
            {Lang.key('copyCode')}
        </div>

        <div>
            <div
                onClick={() => {
                    copyTextToClipboard(msgAuthData?.code?.toString() ?? '');
                }}
                className="text-2xl relative bg-white dark:bg-black text-center px-2 py-2 rounded-sm cursor-pointer active:opacity-50 border-2 border-dashed border-gray-400 mx-2"
            >
                {msgAuthData?.code}

                <span className="absolute top-2 right-2 opacity-50">
                    <LuCopy />
                </span>
            </div>
        </div>


        <div className="my-2  px-2">
            <span className='text-xl font-bold'>2. </span>

            {Lang.key('selectMessenger')}

        </div>

        <div>
            <div className="flex items-center justify-around mt-4">
                {msgAuthData?.links?.map((val) => {
                    return (
                        <div
                            onClick={() => {
                                window.open(val.link);
                            }}
                        >
                            <img
                                className="w-12 h-12 rounded-lg cursor-pointer active:opacity-50"
                                src={val.image}
                            />
                        </div>
                    );
                })}
            </div>
        </div>

        <div className="my-2  px-2">
            <span className='text-xl font-bold'>3. </span>
            {Lang.key('autoLogin')}

        </div>


        <div className="bg-white rounded-md dark:bg-black">
            <div className="flex items-center justify-start flex mt-6">
                <div>
                    <QRCode
                        size={200}
                        value={`https://api.auth4app.com/code/link/${msgAuthData?.code_id}`}
                    />
                </div>
                <div className="px-2 mt-2 text-xs">
                    {Lang.key('scanQRCode')}
                </div>
            </div>
        </div>
    </>
}

export default LoginAuth4App;