import { IoMdArrowBack } from 'react-icons/io';

import {
    MobileLink,
    MobileNavbar,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';

const LoginHeader = ({ title, onBack }: { title: string, onBack?: () => void }) => {

    const { isMobile, icon, title: appTitle } = useAppConfig();


    if (isMobile) {

        return <MobileNavbar
            left={onBack ? <MobileLink onClick={onBack}> <IoMdArrowBack /> </MobileLink> : <img src={icon} className='w-8 h-8 rounded-sm mr-2' />}
            title={appTitle}
            subtitle={title}
        />


    }


    return <div className="text-3xl font-medium mb-2 flex items-center" >
        {onBack && <span
            className='cursor-pointer active:opacity-50'
            onClick={() => {
                onBack?.();
            }}>
            <IoMdArrowBack />
        </span>}
        <span>
            {title}
        </span>
    </div>

}

export default LoginHeader;