import { LogIn } from 'lucide-react';

import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import {
    MobileBlock,
    MobileButton,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

const LoginMailAuthInput = ({ login, setLogin, onEmailPrepare, loading }: { login: string, setLogin: (login: string) => void, onEmailPrepare: () => void, loading: boolean }) => {


    const { isMobile, auth } = useAppConfig();


    if (!auth?.emailLogin) {
        return null;
    }


    if (isMobile) {
        return <>
            <MobileBlock outline>
                <Input
                    id="login"
                    name='login'

                    icon={<LogIn />}
                    className="my-2"
                    value={login}
                    onChange={(e) => setLogin(e.target.value.trim())}
                    placeholder={Lang.key('emailOrLogin')}

                    onKeyPress={(event: any) => {
                        if (event.key === 'Enter') {
                            onEmailPrepare();
                        }
                    }}
                />

                <MobileButton

                    className='mt-2'
                    disabled={loading || !login}
                    onClick={onEmailPrepare}
                >{Lang.key('continue')}</MobileButton>
            </MobileBlock>

        </>
    }


    return <>

        <Input
            id="login"
            name='login'

            icon={<LogIn />}
            className="my-2"
            value={login}
            onChange={(e) => setLogin(e.target.value.trim())}
            placeholder={Lang.key('emailOrLogin')}

            onKeyPress={(event: any) => {
                if (event.key === 'Enter') {
                    onEmailPrepare();
                }
            }}
        />



        <Button
            disabled={loading || !login}
            onClick={onEmailPrepare}

            className='mt-2 w-full'

        >{Lang.key('continue')}</Button>


    </>


}

export default LoginMailAuthInput;