import { MobilePage } from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';

import Tilt3DImage from './Tilt3DImage';

const LoginPageWrapper = (props: any) => {


    const { isMobile, auth, color, cover, icon, subtitle, title, terms, privacy } = useAppConfig();


    if (isMobile) {
        return <MobilePage>

            {props.children}
        </MobilePage>
    }

    return (
        <div
            className={`w-screen h-screen flex bg-gray-400 items-center overflow-hidden `}
            style={{
                backgroundColor: color ?? '',
            }}
        >
            {!!cover ? (
                <Tilt3DImage
                    imageUrl={cover ?? ''}
                />
            ) : (
                <div
                    className=" absolute top-0 right-0 w-full h-full "
                    style={{
                        zIndex: 0,
                        opacity: 0.5,
                        backgroundColor: color ?? '',
                    }}
                ></div>
            )}
            <div className="h-screen w-screen bg-black/50 z-50 overflow-hidden">
                <div className="grid  gap-4 grid-cols-12 w-screen h-screen z-50 max-w-[1280px] mx-auto">
                    <div className="col-start-2 col-span-5  h-screen flex items-center md:hidden lg:hidden xl:flex ">
                        <div className="text-white">
                            <div className="relative">
                                <img
                                    style={{
                                        objectFit: 'cover',
                                    }}
                                    className="w-12 h-12 rounded-lg shadow-sm"
                                    src={icon}
                                ></img>

                            </div>
                            <div className="text-4xl font-bold ">
                                {title}
                            </div>
                            <div className="text-[20px] font-light">
                                {subtitle}
                            </div>
                        </div>
                    </div>
                    <div
                        className="
              md:col-span-8 md:col-start-3
              lg:col-start-4 lg:col-span-6 xl:col-span-5   h-screen flex items-center"
                    >
                        <div className=" bg-white dark:bg-gray-900 py-10 px-14 rounded-md w-full">
                            {props.children}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );

}


export default LoginPageWrapper;