import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

const LoginTerms = () => {

    const { terms, privacy, auth } = useAppConfig();

    if (auth?.emailReg || auth?.phoneReg || auth?.socialReg) {

        return <div className='mt-6 text-xs text-center'>{Lang.key('termsOfUse')} <a target='_blank' href={terms} >{Lang.key('termsOfUseLink')}</a> {Lang.key('and')} <a target='_blank' href={privacy} >{Lang.key('privacyPolicyLink')}</a></div>
    }
    return null;

}

export default LoginTerms;