import { Button } from '@/components/ui/button';
import {
    MobileBlock,
    MobileButton,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

import OrLine from './OrLine';

const PhoneLoginButton = ({ onClick }: { onClick: () => void }) => {

    const { isMobile, auth } = useAppConfig();

    if (!auth?.phoneLogin) {
        return null;
    }

    if (isMobile) {
        return <>
            <MobileBlock>
                <MobileButton

                    outline

                    className='w-full'
                    onClick={onClick}

                >{Lang.key('phoneLogin')}</MobileButton>
            </MobileBlock>
        </>
    }

    return <>

        <OrLine />

        <Button

            variant='outline'

            className='w-full'
            onClick={onClick}

        >{Lang.key('phoneLogin')}</Button>
    </>
}

export default PhoneLoginButton;