import React, { useState } from 'react';

import { XIcon } from 'lucide-react';

import {
    generatePassword,
} from '@/components/CollectionFields/components/ItemData/PasswordData';
import { Button } from '@/components/ui/button';
import {
    Dialog,
    DialogContent,
    DialogTitle,
} from '@/components/ui/dialog';
import { Input } from '@/components/ui/input';
import {
    MobileBlock,
    MobileButton,
    MobileLink,
    MobileNavbar,
    MobilePage,
    MobilePopup,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

const ChangePasswordDialog = ({ open, onClose, onSaveNewPassword }: { open: boolean, onClose: () => void, onSaveNewPassword: (password: string) => void }) => {

    const [localValue, setLocalValue] = useState<string | null>(null);

    const { isMobile } = useAppConfig();

    if (isMobile) {

        return <MobilePopup
            opened={open}
            onBackdropClick={onClose}
        >
            <MobilePage>
                <MobileNavbar
                    title={Lang.key('change_password')}
                    right={<MobileLink onClick={onClose}><XIcon /></MobileLink>}
                />

                <MobileBlock outline>
                    <Input
                        className='w-full'
                        value={localValue ?? ''}
                        placeholder={Lang.key('enter_new_password')}
                        onChange={(e) => setLocalValue(e.target.value)}
                    />

                </MobileBlock>
                <MobileBlock outline>
                    <MobileButton

                        outline
                        style={{ width: '100%' }}
                        onClick={() => setLocalValue(generatePassword(16))}
                    >
                        {Lang.key('generate_random_password')}
                    </MobileButton>



                    <MobileButton
                        className='mt-4'
                        disabled={!localValue}
                        onClick={() => {
                            if (localValue) {
                                onSaveNewPassword(localValue);
                                onClose();
                            }
                        }}>
                        {Lang.key("save_new_password")}
                    </MobileButton></MobileBlock>

            </MobilePage>
        </MobilePopup>
    }

    return <Dialog
        open={open}

        onOpenChange={(val) => {
            if (!val) {
                onClose();
            }
        }}
    >


        <DialogContent >
            <DialogTitle>{Lang.key('change_password')}</DialogTitle>
            <Input
                className='w-full'
                value={localValue ?? ''}
                onChange={(e) => setLocalValue(e.target.value)}
            />

            <Button

                variant="outline"
                style={{ width: '100%' }}
                onClick={() => setLocalValue(generatePassword(16))}
            >
                {Lang.key('generate_random_password')}
            </Button>



            <Button
                disabled={!localValue}
                onClick={() => {
                    if (localValue) {
                        onSaveNewPassword(localValue);
                        onClose();
                    }
                }}>
                {Lang.key("save_new_password")}
            </Button>
            <Button onClick={onClose}>
                {Lang.key("cancel")}
            </Button>
        </DialogContent>
    </Dialog>
}


export default ChangePasswordDialog;