
export default class SVGCacheService {

    static cached: {
        [key: string]: string;
    } = {}


    static async getSvg(uri?: string) {

        if (!uri) return null;


        if (this.cached[uri]) {
            return this.cached[uri];
        }

        const load = await fetch(uri);
        const text = await load.text();
        this.cached[uri] = text;
        return text;
    }
}
