import { StructureType } from '@/api/types';

type CanAccessType = {
    canCreate: () => boolean;
    canUpdate: () => boolean;
    canDelete: () => boolean;
}

export const canAccess = (structure: StructureType | null | undefined): CanAccessType => {


    if (!structure) return {
        canCreate: () => false,
        canUpdate: () => false,
        canDelete: () => false,
    }


    return {


        canCreate: () => {

            if (structure?.single) return false;

            return structure.canCreate ?? false;
        },
        canUpdate: () => {
            return structure.canUpdate ?? false;
        },
        canDelete: () => {



            if (structure?.single) return false;
            return structure.canDelete ?? false;
        },



    }


}
