# Go Worker Service

Фоновый процесс (worker/daemon) на Go для выполнения постоянных задач (очереди, периодические задачи и т.д.).

## Запуск

```bash
cd services/go
go mod tidy
go run main.go
```

Конфигурация автоматически загружается из `config/config.php` PHP проекта.

Можно указать путь к корню проекта через переменную окружения:
```bash
SHM_ROOT_DIR=/path/to/project go run main.go
```

## Запуск как процесс (systemd)

Создайте файл `/etc/systemd/system/shm-go-worker.service`:

```ini
[Unit]
Description=SHM Go Worker Service
After=network.target

[Service]
Type=simple
User=www-data
WorkingDirectory=/path/to/schema/services/go
ExecStart=/usr/local/bin/go-worker
Restart=always
RestartSec=5

[Install]
WantedBy=multi-user.target
```

Затем:
```bash
sudo systemctl daemon-reload
sudo systemctl enable shm-go-worker
sudo systemctl start shm-go-worker
```

## Сборка

```bash
go build -o go-worker main.go
```

## Взаимодействие с PHP

Go worker работает как фоновый процесс и может:
- Обрабатывать задачи из очереди (Redis, RabbitMQ и т.д.)
- Выполнять периодические задачи
- Мониторить состояние системы
- Обрабатывать данные в фоне

PHP код может добавлять задачи в очередь, которую обрабатывает Go worker.
