<?php

namespace Shm\ShmAdmin\AdminRPC;

use Shm\Shm;
use Shm\ShmAdmin\AdminPanel;
use Shm\ShmAuth\Auth;
use Shm\ShmRPC\ShmRPC;
use Shm\ShmUtils\I18n;
use Shm\ShmUtils\Response;

class AdminRPCDeleteData
{
    public static function rpc()
    {

        return ShmRPC::lazy(function () {

            return [
                'type' => Shm::bool(),
                'args' => Shm::structure([

                    "_ids" => Shm::IDs()->default(null),
                    "collection" => Shm::nonNull(Shm::string()),
                ]),
                'resolve' => function ($root, $args) {

                    Auth::authenticateOrThrow(...AdminPanel::$authStructures);

                    if (!isset($args['collection'])) {
                        Response::validation(I18n::get('data_not_available_for_view'));
                    }



                    $structure = AdminPanel::fullSchema()->findItemByCollection($args['collection']);


                    $_ids = $args['_ids'] ?? null;

                    if (!$_ids) {
                        Response::validation(I18n::get('no_data_to_delete'));
                    }


                    if (!$structure) {
                        Response::validation(I18n::get('data_not_available_for_view'));
                    }


                    $structure->deleteMany([
                        '_id' => ['$in' => $_ids]
                    ]);

                    return true;
                }
            ];
        });
    }
}
