<?php

namespace Shm\ShmLog;

use Shm\ShmUtils\ShmInit;

class ShmLog
{

    public static function log(string $message, string $prefix = 'shm')
    {


        $logDir = ShmInit::$rootDir . '/logs';



        if (!is_dir($logDir)) {
            mkdir($logDir, 0777, true);
        }




        $logFile = $logDir . '/' . $prefix . '-' .  date('Y-m-d') . '.log';

        $message = date('Y-m-d H:i:s') . ' ' . $message;
        file_put_contents($logFile, $message . PHP_EOL, FILE_APPEND);
    }
}
