import './App.css';

import { useEffect } from 'react';

import {
  createHashRouter,
  Navigate,
} from 'react-router';
import { RouterProvider } from 'react-router/dom';

import { rpcClient } from './api/request';
import ActionDialog, { actionDialogRef } from './components/ActionDialog';
import AudioRecordDialog, {
  audioRecordDialogRef,
} from './components/AudioRecordDialog';
import CollectionFieldsDialog, {
  collectionFieldsDialogRef,
} from './components/CollectionFieldsDialog';
import CollectionViewStack
  from './components/CollectionView/CollectionViewStack';
import ConfirmAlert, { confirmAlertRef } from './components/ConfirmAlert';
import DialogRegionEditor, {
  dialogRegionEditorRef,
} from './components/DialogRegionEditor';
import ExportDialog, { exportDialogRef } from './components/ExportDialog';
import {
  GeoSearchCommand,
  geoSearchCommandRef,
} from './components/GeoSearchCommand';
import GeoSelectMapCommand, {
  geoSelectMapCommandRef,
} from './components/GeoSelectMapCommand';
import {
  IDSearchCommand,
  idSearchCommandRef,
} from './components/IDsSearchCommand/IDSearchCommand';
import {
  IDsSearchCommand,
  idsSearchCommandRef,
} from './components/IDsSearchCommand/IDsSearchCommand';
import InputDialog, { inputDialogRef } from './components/InputDialog';
import MediaBrowserDialog, {
  mediaBrowserDialogRef,
} from './components/MediaBrowserDialog';
import ReadExcelFileModal, {
  readExcelFileModalRef,
} from './components/ReadExcelFileModal';
import ToastRoot, {
  toast,
  toastRootRef,
} from './components/ToastRoot';
import {
  getFullURL,
  IS_DEV,
} from './config';
import { AppConfigProvider } from './contexts/AppConfigContext';
import { Lang } from './lang/Lang';
import LoginPage from './pages/LoginPage/LoginPage';
import MainPage from './pages/MainPage.tsx/MainPage';

const router = createHashRouter([
  {
    path: "/",
    element: localStorage.getItem("token") ? <MainPage /> : <LoginPage />,
  },
  {
    path: "/*",
    element: <Navigate to="/" replace />,
  },
], {
  future: {
    v7_normalizeFormMethod: true,
  },
});


rpcClient.setToken(() => localStorage.getItem("token"));
rpcClient.setEndpoints([getFullURL()])

if (window.location.hostname === "localhost") {
  rpcClient.setUseEncrypt(false);
} else {
  rpcClient.setUseEncrypt(true);
}

rpcClient.setToast((message) => {
  toast.error(message);
});

rpcClient.setUnauthorizedHandler(() => {
  localStorage.removeItem("token");
  window.location.reload();
});

if (!IS_DEV) {

  console.log = () => { };
  console.error = () => { };
  console.warn = () => { };
  console.info = () => { };
  console.debug = () => { };
  console.trace = () => { };
  console.dir = () => { };
  console.dirxml = () => { };
  console.group = () => { };
  console.groupEnd = () => { };
  console.time = () => { };
  console.timeEnd = () => { };
  console.timeLog = () => { };
  console.timeStamp = () => { };
  console.count = () => { };
  console.countReset = () => { };
  console.groupCollapsed = () => { };
  console.groupEnd = () => { };
}

const App = () => {
  useEffect(() => {
    Lang.initLang();
  }, []);
  return (
    <AppConfigProvider>
      <RouterProvider router={router} />


      <ToastRoot ref={toastRootRef} />
      <CollectionViewStack />
      {/*  <CollectionView collection="users" _id="1" />*/}
      <GeoSearchCommand ref={geoSearchCommandRef} />
      <GeoSelectMapCommand ref={geoSelectMapCommandRef} />
      <IDSearchCommand ref={idSearchCommandRef} />
      <IDsSearchCommand ref={idsSearchCommandRef} />
      <AudioRecordDialog ref={audioRecordDialogRef} />
      <CollectionFieldsDialog ref={collectionFieldsDialogRef} />
      <ActionDialog ref={actionDialogRef} />
      <ConfirmAlert ref={confirmAlertRef} />
      <ExportDialog ref={exportDialogRef} />
      <ReadExcelFileModal ref={readExcelFileModalRef} />
      <DialogRegionEditor ref={dialogRegionEditorRef} />
      <MediaBrowserDialog ref={mediaBrowserDialogRef} />
      <InputDialog
        ref={inputDialogRef}
      />

    </AppConfigProvider>
  );
}

export default App
