export interface RpcError {
  type: 'UNAUTHORIZED' | 'VALIDATION_ERROR' | 'NOT_FOUND' | 'INTERNAL_ERROR' | 'FORBIDDEN' | 'RATE_LIMITED' | string;
  message: string;
  code?: number;
}

export interface RpcResponse<T = unknown, Extensions = unknown> {
  datetime: number;
  success: boolean;
  result: T | null;
  extensions: Extensions | null;
  error: RpcError | null;
}

export type ActionMSEnum = "sendMessage"|"makeCall";
export type ActionPositionISTEnum = "sidebar"|"inline"|"table";
export type AllItemGIKTType = {
key?: string,
icon?: string,
title?: string,
group?: string
};
export type ApikeyACITType = {
_id?: string,
apikey?: string,
title?: string,
last_used?: number,
created_at?: number
};
export type ArgsAddBiBoardInput = {
title?: string,
blocks?: BiBlockInput[]
};
export type ArgsAuthEmailInput = {
withEmailCode?: boolean,
code?: number,
login: string,
password?: string,
deviceInfo?: DeviceInfoMNPUInput
};
export type ArgsAuthEmailPrepareInput = {
login: string
};
export type ArgsAuthPhoneInput = {
set?: boolean,
phone: string,
code_id?: string,
deviceInfo?: DeviceInfoMNPUInput
};
export type ArgsAuthSocInput = {
unsetId?: string,
set?: boolean,
key?: string,
deviceInfo?: DeviceInfoMNPUInput
};
export type ArgsCalculateBiBlockInput = {
uuid?: string,
type?: BiBlockEnum,
title?: string,
source?: string,
filter?: any,
groupTransform?: BiGroupTransformEnum,
groupByField?: string,
valueField?: string,
aggregateType?: BiAggregateEnum
};
export type ArgsCollectionInput = {
collection: string
};
export type ArgsDataInput = {
_id?: string,
table?: boolean,
collection: string,
limit?: number,
offset?: number,
search?: string,
sort?: SortDFInput,
filter?: any,
pipeline?: any
};
export type ArgsDeleteBiBoardInput = {
_id?: string
};
export type ArgsDeleteDataInput = {
_ids?: string[],
collection: string
};
export type ArgsDeleteExportInput = {
_id?: string
};
export type ArgsDisplayValuesInput = {
collection: string,
ids?: string[],
limit?: number,
offset?: number,
search?: string,
filter?: any
};
export type ArgsEmptyDataInput = {
clone?: string,
collection: string
};
export type ArgsFilterInput = {
collection: string
};
export type ArgsGeneratePaymentLinkInput = {
currency: string,
gateway: string,
amount: number
};
export type ArgsGeocodeInput = {
byCoords?: ByCoordLInput,
byString?: ByStringLSInput
};
export type ArgsGeolocationInput = {
ip?: string
};
export type ArgsHashInput = {
_id?: string,
collection: string,
limit?: number,
offset?: number,
search?: string,
sort?: SortDFInput,
filter?: any,
pipeline?: any
};
export type ArgsMakeExportInput = {
ids?: string[],
title?: string,
collection: string,
filter?: any,
pipeline?: any
};
export type ArgsMakeStatementExportInput = {
currency: string
};
export type ArgsMoveUpdateInput = {
_id?: string,
collection?: string,
aboveId?: string,
belowId?: string
};
export type ArgsNewApiKeyInput = {
title?: string
};
export type ArgsRemoveApiKeyInput = {
_id?: string
};
export type ArgsRunActionInput = {
collection: string,
action: string,
args?: any
};
export type ArgsStagesTotalInput = {
collection: string,
search?: string,
filter?: any
};
export type ArgsUpdateBiBoardInput = {
_id?: string,
board?: ShmBiBoardInput
};
export type ArgsUpdateInput = {
_ids?: string[],
collection: string,
values?: any
};
export type ArgsUpdateProfileInput = {
values?: any
};
export type AssetCIPTType = {
icon?: string,
cover?: string,
color?: string,
subtitle?: string,
terms?: string,
privacy?: string
};
export type AuthEPSType = {
emailLogin?: boolean,
phoneLogin?: boolean,
socialLogin?: boolean,
emailReg?: boolean,
phoneReg?: boolean,
socialReg?: boolean
};
export type AuthEmailPrepareCFIType = {
find?: boolean,
isEmail?: boolean,
canRegister?: boolean
};
export type BalanceFPType = {
field?: StructureType,
path?: string
};
export type BalancePaymentType = {
_id?: string,
amount?: number,
currency?: string,
description?: string,
created_at?: number,
beforeBalance?: number,
afterBalance?: number
};
export type BiAggregateEnum = "countRoot"|"sum"|"avg"|"min"|"max";
export type BiBlockEnum = "chart"|"pie"|"table"|"square"|"funnel"|"abc"|"xyz";
export type BiBlockInput = {
type?: BiBlockEnum,
title?: string,
source?: string,
filter?: any,
groupTransform?: BiGroupTransformEnum,
groupByField?: string,
valueField?: string,
aggregateType?: BiAggregateEnum
};
export type BiBlockType = {
uuid?: string,
type?: BiBlockEnum,
title?: string,
source?: string,
filter?: any,
groupTransform?: BiGroupTransformEnum,
groupByField?: string,
valueField?: string,
aggregateType?: BiAggregateEnum,
colSpan?: number,
rowSpan?: number
};
export type BiBlockValueItemType = {
key?: any,
value?: any
};
export type BiBlockValueType = {
values?: BiBlockValueItemType[],
keyTransform?: BiGroupTransformEnum
};
export type BiGroupTransformEnum = "hour"|"day"|"month"|"year"|"week";
export type ByCoordLInput = {
latitude?: number,
longitude?: number
};
export type ByStringLSInput = {
string?: string,
latutude?: number,
longitude?: number
};
export type CollectionCDRSType = {
structure?: StructureType,
descriptions?: FieldDescriptionType,
relations?: CollectionRelationType[],
collectionMenu?: CollectionMenuAMType
};
export type CollectionMenuAMType = {
menu?: MenuCGITType[],
allItems?: AllItemGIKTType[]
};
export type CollectionRelationType = {
icon?: string,
title?: string,
subtitle?: string,
collection?: string,
key?: string
};
export type CompositeTypeGType = {
geoPoint?: GeopointType,
geoRegion?: GeoRegionGType[],
gradient?: GradientAPType
};
export type DTType = {
titleRU?: string,
titleEN?: string,
descriptionEN?: string,
descriptionRU?: string
};
export type DashboardBlockTypeBCLPEnum = "card"|"lineChart"|"pieChart"|"barChart";
export type DatumDHLTType = {
data?: DatumIMType[],
limit?: number,
hash?: string,
offset?: number,
total?: number
};
export type DatumDIType = {
_id?: string,
displayValue?: string
};
export type DatumIMType = {
_id?: string,
[key: string]: any
};
export type DeviceInfoMNPUInput = {
name?: string,
model?: string,
platform?: string,
uuid?: string
};
export type DirectionADEnum = "ASC"|"DESC";
export type DisplayValueDLOTType = {
data?: DatumDIType[],
limit?: number,
offset?: number,
total?: number
};
export type EmptyDatumIMType = {
_id?: string,
[key: string]: any
};
export type FieldDescriptionItemType = {
descriptionEN?: string,
descriptionRU?: string,
titleEN?: string,
titleRU?: string,
values?: ValueMType,
items?: FieldDescriptionType
};
export type FieldDescriptionType = {
[key: string]: FieldDescriptionItemType
};
export type FileAudioFileType = {
_id?: string,
fileType?: string,
name?: string,
url?: string,
duration?: number,
type?: string,
created_at?: string
};
export type FileDocumentFileType = {
_id?: string,
fileType?: string,
name?: string,
url?: string,
type?: string,
created_at?: string
};
export type FileImageFileType = {
_id?: string,
fileType?: string,
name?: string,
url?: string,
url_medium?: string,
url_small?: string,
blurhash?: string,
width?: number,
height?: number,
type?: string,
created_at?: number
};
export type FileVideoFileType = {
_id?: string,
fileType?: string,
name?: string,
url?: string,
cover?: string,
duration?: number,
width?: number,
height?: number,
type?: string,
created_at?: number
};
export type FilterPresetFKTType = {
key?: string,
title?: string,
filter?: any
};
export type GatewayDIKTType = {
minAmount?: number,
maxAmount?: number,
title?: string,
description?: string,
icon?: string,
key?: string
};
export type GeoRegionGType = {
geometry?: MongoPolygonType
};
export type GeolocationILType = {
latitude?: number,
longitude?: number,
ip?: string
};
export type GeopointType = {
uuid?: string,
/**
 * @deprecated Use "name" instead
 */
address?: string,
name?: string,
context?: string,
meta?: MetumACFPType,
grid?: string,
lat?: number,
lng?: number,
location?: MongoPointType
};
export type GradientAPType = {
palette?: PaletteCOType[],
angle?: number
};
export type GroupIKTType = {
key?: string,
icon?: string,
title?: string
};
export type InitACPTType = {
auth?: AuthEPSType,
title?: string,
icon?: string,
cover?: string,
color?: string,
subtitle?: string,
terms?: string,
privacy?: string
};
export type ItemMType = {
[key: string]: StructureType
};
export type MenuAMType = {
menu?: MenuItemType[],
allItems?: MenuItemType[]
};
export type MenuCGITType = {
key?: string,
icon?: string,
title?: string,
group?: string,
children?: childGIKTType[]
};
export type MenuItemChildType = {
label?: string,
icon?: string,
key?: string,
collection?: string,
single?: boolean
};
export type MenuItemType = {
label?: string,
icon?: string,
key?: string,
collection?: string,
single?: boolean,
children?: MenuItemChildType[]
};
export type MetumACFPType = {
label?: string,
floor?: string,
entrance?: string,
apartment?: string,
comment?: string,
phone?: number
};
export type MongoPointType = {
type?: string,
coordinates?: number[]
};
export type MongoPolygonType = {
type?: "Polygon",
coordinates?: number[][][]
};
export type PaletteCOType = {
color?: string,
opacity?: number,
offset?: string
};
export type PayloadUType = {
url?: string
};
export type ProfileBCDSType = {
structure?: StructureType,
data?: any,
changePassword?: boolean,
subAccount?: boolean,
balances?: BalanceFPType[]
};
export type RunActionPType = {
payload?: PayloadUType
};
export type ShmBiBoardInput = {
title?: string,
blocks?: BiBlockInput[]
};
export type ShmBiBoardType = {
title?: string,
blocks?: BiBlockType[],
_id?: string,
created_at?: number,
updated_at?: number
};
export type ShmExportType = {
type?: TypeDSEnum,
fileName?: string,
fileUrl?: string,
timezone?: string,
title?: string,
currency?: string,
collection?: string,
pipeline?: any,
progress?: number,
error?: string,
status?: StatusDEPEnum,
_id?: string,
created_at?: number,
updated_at?: number
};
export type ShmMsgAuthLinkType = {
title?: string,
action?: ActionMSEnum,
contact?: string,
link?: string,
image?: string,
color?: string
};
export type ShmMsgAuthType = {
auth?: boolean,
token?: string,
code?: number,
qrLink?: string,
code_id?: string,
links?: ShmMsgAuthLinkType[],
otherLinks?: ShmMsgAuthLinkType[]
};
export type SortDFInput = {
direction?: DirectionADEnum,
field?: string
};
export type StagesTotalMType = {
[key: string]: number
};
export type StatusDEPEnum = "pending"|"processing"|"done"|"error";
export type StructureType = {
collection?: string,
key?: string,
itemType?: StructureType,
codeLang?: string,
manualSort?: boolean,
filterPresets?: FilterPresetFKTType[],
args?: StructureType,
actionPosition?: ActionPositionISTEnum,
filterType?: StructureType,
items?: ItemMType,
columnsWidth?: number,
values?: ValueMType,
haveCalculateFunction?: boolean,
dashboardBlockType?: DashboardBlockTypeBCLPEnum,
gateways?: GatewayDIKTType,
apikey?: boolean,
tablePriority?: number,
unique?: boolean,
report?: boolean,
globalUnique?: boolean,
canUpdateCond?: any,
display?: boolean,
displayPrefix?: string,
trim?: boolean,
uppercase?: boolean,
currency?: string,
currencySymbol?: string,
accept?: string,
canUpdate?: boolean,
canDelete?: boolean,
canCreate?: boolean,
hide?: boolean,
single?: boolean,
min?: number,
max?: number,
editable?: boolean,
inAdmin?: boolean,
inTable?: boolean,
col?: number,
required?: boolean,
nullable?: boolean,
default?: any,
title?: string,
type?: TypeABCDEFGHILMPRSTUEnum,
cond?: any,
localCond?: any,
defaultIsSet?: boolean,
assets?: AssetCIPTType,
group?: GroupIKTType
};
export type TypeABCDEFGHILMPRSTUEnum = "fileAudio"|"fileDocumentLink"|"fileDocument"|"fileImageID"|"fileVideoID"|"fileAudioID"|"fileAudioLink"|"fileDocumentID"|"fileImageLink"|"fileImage"|"fileVideo"|"enum"|"enums"|"string"|"structure"|"color"|"unixdatetime"|"mixed"|"bool"|"float"|"int"|"selfRef"|"uuid"|"social"|"url"|"text"|"html"|"time"|"range"|"IDs"|"geopoint"|"array"|"phone"|"ID"|"code"|"unixdate"|"mongoPoint"|"adminGroup"|"dashboard"|"admin"|"login"|"password"|"email"|"mongoPolygon"|"rate"|"gradient"|"report"|"geoRegion"|"balance"|"action";
export type TypeDSEnum = "statement"|"data";
export type UpdateDType = {
data?: DatumIMType[]
};
export type UpdateProfileIMType = {
_id?: string,
[key: string]: any
};
export type ValueMType = {
[key: string]: string
};
export type childGIKTType = {
key?: string,
icon?: string,
title?: string,
group?: string
};