import { BiBlockEnum } from '@/api/types';

/**
 * Определяет размеры блока на основе его типа
 * @param type - тип блока
 * @returns объект с colSpan и rowSpan
 */
export const getBlockSizes = (type?: BiBlockEnum): { colSpan: number; rowSpan: number } => {
    switch (type) {
        case "square":
            return { colSpan: 4, rowSpan: 1 };
        case "pie":
            return { colSpan: 8, rowSpan: 2 };
        case "chart":
            return { colSpan: 8, rowSpan: 2 };
        case "table":
            return { colSpan: 12, rowSpan: 3 };
        case "funnel":
            return { colSpan: 8, rowSpan: 2 };
        case "abc":
            return { colSpan: 12, rowSpan: 3 };
        case "xyz":
            return { colSpan: 12, rowSpan: 3 };
        default:
            return { colSpan: 8, rowSpan: 2 };
    }
};
