import _ from 'lodash';

import {
    FieldDescriptionType,
    StructureType,
} from '@/api/types';
import { IS_DEV } from '@/config';
import { EventEmitter } from '@/utils/event';

import { RowCSS } from './components/GridCss';
import ItemData from './components/ItemData/ItemData';

export type CollectionFieldsProps = {
    structure: StructureType | null;
    valuesRef: React.RefObject<any>;
    groupKey?: string | null;
    noPaddingBottom?: boolean;
    inline?: boolean;
    onlyShow?: boolean;
    descriptions?: FieldDescriptionType | null;
}

const CollectionFields = ({ structure, valuesRef, groupKey, noPaddingBottom, inline = false, onlyShow = false, descriptions }: CollectionFieldsProps) => {

    if (!structure) {
        return null;
    }

    const Content = ({ children }: { children: React.ReactNode }) => {

        if (inline) {
            return <div className='flex flex-wrap gap-4'>
                {children}
            </div>
        }


        return <div
            className='overflow-y-auto flex-1 p-4'
        >


            <RowCSS style={{
                // maxWidth: 1024,
                //  marginLeft: "auto",
                //  marginRight: "auto",
                //  paddingTop: "2rem",
                paddingBottom: noPaddingBottom ? '0' : '30vh'// "2rem",

            }}>
                {children}
            </RowCSS>
        </div>


    }


    if (structure.type == 'structure' && _.size(structure.items) > 0) {

        return <Content>
            {_.map(!!groupKey ? _.filter(structure.items, (item: StructureType) => item.group?.key === groupKey) : structure.items, (field: StructureType) => {

                if (!field) {
                    return null;
                }

                return <ItemData
                    inline={inline}

                    structureLevel={0}



                    descriptions={descriptions?.[field?.key!] ?? null}


                    onlyShow={onlyShow}
                    arrayLevel={0}
                    parent={null}
                    rootParent={null}
                    getDataStructure={() => {
                        return structure;
                    }}

                    getParentValue={() => {



                        return valuesRef.current;
                    }}
                    getDataValue={() => {
                        return valuesRef.current;
                    }}

                    getValue={() => {
                        return !!field?.key ? valuesRef.current[field?.key] ?? undefined : undefined;
                    }}
                    setValue={(value: any) => {

                        valuesRef.current[field.key!] = value;

                        // store.setValueData(field.key!, value);

                        EventEmitter.execute("updateField", field.key);

                        if (IS_DEV) {

                            console.log("DEV: Update field Event", field.key, value);
                        }

                        // EventEmitter.execute(key);
                    }}



                    structure={field} />
            })}


        </Content>
    }



    return <Content >

        <ItemData
            inline={inline}

            structureLevel={0}

            onlyShow={onlyShow}

            descriptions={descriptions}
            arrayLevel={0}
            parent={null}
            rootParent={null}
            getDataStructure={() => {
                return structure;
            }}

            getParentValue={() => {



                return valuesRef.current;
            }}
            getDataValue={() => {
                return valuesRef.current;
            }}

            getValue={() => {
                return !!structure?.key ? valuesRef.current[structure?.key] ?? undefined : undefined;
            }}
            setValue={(value: any) => {

                valuesRef.current[structure.key!] = value;

                // store.setValueData(field.key!, value);

                EventEmitter.execute("updateField", structure.key);

                if (IS_DEV) {

                    console.log("DEV: Update field Event", structure.key, value);
                }

                // EventEmitter.execute(key);
            }}



            structure={structure} />


    </Content>



}



export default CollectionFields;