import {
  useEffect,
  useState,
} from 'react';

import {
  Check,
  XIcon,
} from 'lucide-react';

import { Button } from '@/components/ui/button';
import { Switch } from '@/components/ui/switch';
import { useAppConfig } from '@/contexts/AppConfigContext';

import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import { ItemDataProps } from './types';

export const BoolData = (props: ItemDataProps) => {



    const [localValue, setLocalValue] = useState(props.getValue());

    useEffect(() => {
        props.setValue(localValue);
    }, [localValue]);

    useEffect(() => {

        if (localValue === undefined || localValue === null) {
            setLocalValue(false);
        }


    }, []);

    const { color } = useAppConfig();


    if (props.onlyShow || !props.structure.editable) {


        return <div>
            <DataLabel {...props} />
            <Button variant="secondary" className='w-full flex items-center justify-between'>
                {!!localValue ? <Check color={color} /> : <XIcon color={color} />}
            </Button>
            <DataDescription {...props} />
        </div>




    }

    return (
        <div className="">
            <DataLabel {...props} />
            <Switch checked={!!localValue ? true : false} onCheckedChange={setLocalValue} />
            <DataDescription {...props} />
        </div>
    );
};


