import {
  useEffect,
  useState,
} from 'react';

import _ from 'lodash';
import {
  Check,
  ChevronsUpDown,
  CopyIcon,
} from 'lucide-react';

import { Button } from '@/components/ui/button';
import {
  Popover,
  PopoverContent,
  PopoverTrigger,
} from '@/components/ui/popover';
import {
  ToggleGroup,
  ToggleGroupItem,
} from '@/components/ui/toggle-group';
import { Lang } from '@/lang/Lang';
import { cn } from '@/lib/utils';
import { copyTextToClipboard } from '@/utils/helpers';

import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import { ItemDataProps } from './types';

export type ItemType = {
  label: string;
  value: string;
};

export const EnumData = (props: ItemDataProps) => {


  const [localValue, setLocalValue] = useState(props.getValue());

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);




  if (props.onlyShow || !props.structure.editable) {


    return <div>
      <DataLabel {...props} />
      <Button variant="secondary" className='w-full flex items-center justify-between overflow-hidden' onClick={() => {
        if (localValue) {
          copyTextToClipboard(props.structure.values?.[localValue] ?? "");
        }
      }}>
        {!!localValue ? props.structure.values?.[localValue] : ' - '} <CopyIcon />
      </Button>
      <DataDescription {...props} />
    </div>



  }




  if (_.size(props.structure.values) < 4 && props.structure.required) {

    return <>

      <DataLabel {...props} />
      <ToggleGroup

        type="single" variant="outline" spacing={2} size="sm" value={localValue} onValueChange={(value) => { setLocalValue(value) }}>

        {_.map(props.structure.values, (value, key) => {
          return (
            <ToggleGroupItem
              value={key}
              data-selected={localValue === key ? "true" : "false"}
            >
              {value}
            </ToggleGroupItem>
          )
        })}


      </ToggleGroup>




    </>
  }


  const [open, setOpen] = useState(false);

  return <div className='w-full '>
    <DataLabel {...props} />


    <Popover open={open} onOpenChange={setOpen}>
      <PopoverTrigger className='w-full' >
        <Button
          variant="outline"
          role="combobox"
          className="w-full justify-between "
        >


          {!!localValue ? props.structure.values?.[localValue] : Lang.key('select_value')}

          <ChevronsUpDown className="opacity-50" />
        </Button>
      </PopoverTrigger>
      <PopoverContent
        className="p-0 w-[var(--radix-popover-trigger-width)]"
      >
        <div
          className="p-1"
          style={{
            maxHeight: '400px',
            overflowY: 'auto',
            overflowX: 'hidden',
            WebkitOverflowScrolling: 'touch'
          }}
          onWheel={(e) => {
            e.stopPropagation();
            const target = e.currentTarget;
            target.scrollTop += e.deltaY;
            e.preventDefault();
          }}
        >
          {_.map(props.structure?.values, (value, key) => (
            <div
              key={key}
              onClick={() => {
                setLocalValue(key);
                setOpen(false);
              }}
              className={cn(
                "relative flex cursor-pointer select-none items-center rounded-sm px-2 py-1.5 text-sm outline-none hover:bg-accent hover:text-accent-foreground",

              )}
            >
              {value}
              <Check
                className={cn(
                  "ml-auto h-4 w-4",
                  localValue === key ? "opacity-100" : "opacity-0"
                )}
              />
            </div>
          ))}
        </div>
      </PopoverContent>
    </Popover>

    <DataDescription {...props} />
  </div>



};
