import {
  useEffect,
  useState,
} from 'react';

import { MongoPolygonType } from '@/api/types';

import OpsItemData from '../../OpsItemData';
import { ItemDataProps } from '../types';

export const PolygonData = (props: ItemDataProps) => {




    const [localValue, setLocalValue] = useState<MongoPolygonType | undefined>(props.getValue());

    useEffect(() => {
        props.setValue(localValue);
    }, [localValue]);

    useEffect(() => {

        if (localValue === undefined || localValue === null) {
            setLocalValue(undefined);
        }


    }, []);


    return <OpsItemData
        {...props}
    />
};


