import 'react-phone-input-2/lib/semantic-ui.css';

import React, {
  useEffect,
  useState,
} from 'react';

import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Lang } from '@/lang/Lang';
import { copyTextToClipboard } from '@/utils/helpers';

import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import { ItemDataProps } from './types';

export const PhoneData = (props: ItemDataProps) => {


  const [localValue, setLocalValue] = useState<string | undefined>(props.getValue());

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);


  if (props.onlyShow || !props.structure.editable) {


    return <div>
      <DataLabel {...props} />
      <Button variant="secondary" className='w-full flex items-center justify-between' onClick={() => {
        if (localValue) {
          copyTextToClipboard(`+${localValue}`);
        }
      }}>
        {localValue ? `+${localValue}` : Lang.key('no_data_short')}
      </Button>
      <DataDescription {...props} />
    </div>



  }


  const onChangePhone = (val: any) => {
    //  if (val) {
    //  val = String(val).replace(/\D/g, '');

    setLocalValue(val);

    //}
  };



  return (
    <React.Fragment>

      <DataLabel {...props} />

      <Input
        phoneInput

        value={localValue ? String(localValue) : undefined}
        onChange={(e) => {
          setLocalValue(e.target.value);
        }}
      />
      <DataDescription {...props} />





    </React.Fragment>
  );
};
