import React, {
  useEffect,
  useState,
} from 'react';

import dayjs from 'dayjs';
import _ from 'lodash';

import { StructureType } from '@/api/types';
import { Button } from '@/components/ui/button';
import { Lang } from '@/lang/Lang';

import { RowCSS } from '../GridCss';
import DataDescription from './components/DataDescription';
import DataLabel from './components/DataLabel';
import ItemData from './ItemData';
import { ItemDataProps } from './types';

export const RangeData = (props: ItemDataProps) => {


  const [localValue, setLocalValue] = useState(props.getValue());

  useEffect(() => {
    props.setValue(localValue);
  }, [localValue]);

  const children = props.structure.items?.from ?? null;





  if (props.onlyShow || !props.structure.editable) {




    if (!localValue?.from && !localValue?.to) {


      return <div>
        <DataLabel {...props} />
        <Button variant="secondary" className='w-full flex items-center justify-between'>
          {Lang.key('no_data_short')}
        </Button>
      </div>


    }


    if (children?.type == "unixdate") {

      return <div>
        <DataLabel {...props} />
        <Button variant="secondary" className='w-full flex items-center justify-between'>
          <div>{dayjs.unix(localValue?.from).format('DD.MM.YYYY')} - {dayjs.unix(localValue?.to).format('DD.MM.YYYY')}</div>
        </Button>
      </div>


    }

    if (children?.type == "unixdatetime") {

      return <div>
        <DataLabel {...props} />
        <Button variant="secondary" className='w-full flex items-center justify-between'>
          <div>{dayjs.unix(localValue?.from).format('DD.MM.YYYY HH:mm')} - {dayjs.unix(localValue?.to).format('DD.MM.YYYY HH:mm')}</div>
        </Button>
      </div>



    }


    if (children?.type == "time") {

      return <div>
        <DataLabel {...props} />
        <Button variant="secondary" className='w-full flex items-center justify-between'>
          <div>{localValue?.from?.h ?? ''}:{localValue?.from?.m ?? ''} - {localValue?.to?.h ?? ''}:{localValue?.to?.m ?? ''}</div>
        </Button>
      </div>



    }

    return <div>
      <DataLabel {...props} />
      <Button variant="secondary" className='w-full flex items-center justify-between'>
        <div>{localValue?.from ?? ''} - {localValue?.to ?? ''}</div>
      </Button>
    </div>



  }






  const getTitle = (item: StructureType) => {

    if (item.key == "from")
      return `${props.structure.title} ${Lang.key('from')}`;

    if (item.key == "to") {
      return `${props.structure.title} ${Lang.key('to')}`;
    }



    return "";
  }


  return (
    <div>
      <DataLabel {...props} />
      <RowCSS>

        {_.map(props.structure?.items, (item, key) => <ItemData

          inline={props.inline}

          getDataStructure={props.getDataStructure}
          structureLevel={0}

          //  hideLabel
          arrayLevel={props.arrayLevel}


          getParentValue={() => {
            return props.getValue();
          }}

          getDataValue={props.getDataValue}

          getValue={() => {

            return props.getValue()?.[key];

          }}
          rootParent={props.parent}
          parent={props.structure}

          setValue={(value: any) => {
            props.setValue({
              ...props.getValue(),
              [key]: value
            });
          }}
          hideLabel={true}

          structure={{
            ...item,

          }}
        />)}

      </RowCSS>
      <DataDescription {...props} />
    </div>
  )
}
