import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

import { ItemDataProps } from '../types';

const DataDescription = (props: ItemDataProps) => {


    if (props.parent?.type == 'array') return null;

    const { hideTips } = useAppConfig();


    if (hideTips) return null;

    let description = "";

    if (Lang.getCurrentLang() == "en" && !!props.descriptions?.descriptionEN) {
        description = props.descriptions.descriptionEN;
    }
    if (Lang.getCurrentLang() == "ru" && !!props.descriptions?.descriptionRU) {
        description = props.descriptions.descriptionRU;
    }



    if (!description) {

        //   if (IS_DEV) return <div className='text-xs text-muted-foreground px-1 text-red-500'>{props.structure.key} {props.structure.type} NO DESCRIPTION</div>

        return null;
    }

    // if (IS_DEV) return <div className='text-xs text-muted-foreground px-1'>{props.structure.key} {props.structure.type} {description}</div>

    return <div className='text-[10px] text-muted-foreground px-1 my-1'>{description}</div>

}

export default DataDescription;