import { ArrowUpRightIcon } from 'lucide-react';

import {
    Empty,
    EmptyDescription,
    EmptyHeader,
    EmptyMedia,
    EmptyTitle,
} from '@/components/ui/empty';
import { Lang } from '@/lang/Lang';

const EmptyTable = ({ title, onCreate }: { title?: string, onCreate?: () => void }) => {
    return (
        <Empty>
            <EmptyHeader>
                <EmptyMedia variant="icon">
                    <ArrowUpRightIcon />
                </EmptyMedia>
                <EmptyTitle>{!!title ? title : Lang.key('empty_table_title')}</EmptyTitle>
                <EmptyDescription>
                    {Lang.key('empty_table_description')}
                </EmptyDescription>
            </EmptyHeader>


        </Empty>
    )
}

export default EmptyTable;