import _ from 'lodash';

import { Badge } from '@/components/ui/badge';

import TableItem, { TableItemProps } from '../TableItem';

const ArrayItem = (props: TableItemProps) => {

    const value = props.value;



    if (!value || _.size(value) === 0)
        return <div className='flex items-center justify-center'>-</div>



    if (props.structure?.itemType?.type == "structure") {


        return <div>
            {_.map(value, (item, index) => {
                return <TableItem
                    value={item}
                    structure={props.structure?.itemType ?? null}
                />
            })}
        </div>




    }



    return <Badge>{_.size(value)}x {props.structure?.title}</Badge>

}

export default ArrayItem;