import _ from 'lodash';

import { Badge } from '@/components/ui/badge';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

const EnumItem = (props: TableItemProps) => {

    const value = props.value;

    const values = props.structure?.values;




    if (!value || !values?.[value]) {
        return <EmptyItem {...props} />;
    }



    //if value include cancel error in string
    const red = value?.includes('cancel') || value?.includes('error') || value?.includes('fail');



    return <div><Badge
        variant={red ? 'destructive' : 'default'}
    >{values?.[value]}</Badge></div>


}

export default EnumItem;