import _ from 'lodash';

import { Badge } from '@/components/ui/badge';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

const EnumsItem = (props: TableItemProps) => {

    const value = props.value;

    const values = props.structure?.itemType?.values;




    if (!value || _.size(value) == 0) {
        return <EmptyItem {...props} />;
    }





    return <div>
        {_.map(value, (val, index) => {

            return <Badge>{values?.[val] ?? " - "}</Badge>

        })}

    </div>


}

export default EnumsItem;