import _ from 'lodash';
import { LuImageOff } from 'react-icons/lu';

import { TableItemProps } from '../TableItem';

const FileItem = (props: TableItemProps) => {

    const value = props.value;




    if (props.structure?.type == "fileImage" || props.structure?.type == "fileImageID") {


        if (!value?.url) {

            return <div className='w-10 h-10 flex items-center justify-center opacity-50'>
                <LuImageOff size={24} />
            </div>
        }

        return <img
            className='w-10 h-10 object-cover rounded-md'
            src={value?.url_small ?? value?.url_medium ?? value?.url}
            alt={props.structure?.title ?? ""}
        />

    }

    if (props.structure?.type == "fileImageLink") {

        if (!value) {
            return <div className='w-10 h-10 flex items-center justify-center  opacity-50'>
                <LuImageOff size={24} />
            </div>
        }


        return <img
            className='w-10 h-10 object-cover rounded-md'
            src={value}
            alt={props.structure?.title ?? ""}
        />

    }


    return <div></div>

}

export default FileItem;