import _ from 'lodash';
import numeral from 'numeral';

import { TableItemProps } from '../TableItem';

const NumberItem = (props: TableItemProps) => {



    let value = props.value ?? 0;




    return <div
        style={{
            opacity: !value ? 0.5 : 1,
            color: +value > 0 ? "green" : +value < 0 ? "red" : "inherit"
        }}
        className="text-center font-medium ">{_.isNumber(value) ? numeral(value).format("0,0[.]00").replace(/,/g, ' ') : ""}</div>

}

export default NumberItem;