//@ts-ignore
import countryCodeEmoji from 'country-code-emoji';
import parsePhoneNumber from 'libphonenumber-js';
import _ from 'lodash';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

const PhoneItem = (props: TableItemProps) => {

    const value = props.value;


    if (!value) return <EmptyItem {...props} />;


    const phoneNumber = parsePhoneNumber('+' + value);


    return <span
        //Не переносить на новую строку
        className="whitespace-nowrap"

    >
        {phoneNumber?.country && (
            <span className="mr-1">
                {countryCodeEmoji(phoneNumber?.country)}
            </span>
        )}

        {!phoneNumber ? '+' + value : phoneNumber.formatInternational()}
    </span>

}

export default PhoneItem;